---
title: Browser Integrity Check · Cloudflare Web Application Firewall (WAF) docs
description: Cloudflare's Browser Integrity Check (BIC) looks for common HTTP
  headers abused most commonly by spammers and denies access to your page.
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/browser-integrity-check/
  md: https://developers.cloudflare.com/waf/tools/browser-integrity-check/index.md
---

Cloudflare's Browser Integrity Check (BIC) looks for common HTTP headers abused most commonly by spammers and denies access to your page.

It also challenges visitors without a user agent or with a non-standard user agent such as commonly used by abusive bots, crawlers, or visitors.

Browser Integrity Check is enabled by default.

## Disable Browser Integrity Check

### Disable globally

To disable BIC globally for your zone:

* Old dashboard

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
  2. Select your account and zone.
  3. Go to **Security** > **Settings**.
  4. Turn off **Browser Integrity Check**.

* New dashboard

  1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com).
  2. Select your account and zone.
  3. Go to **Security** > **Settings** and filter by **DDoS attacks**.
  4. Turn off **Browser integrity check**.

### Disable selectively

To disable BIC selectively, you can skip Browser Integrity Check using a [custom rule with a skip action](https://developers.cloudflare.com/waf/custom-rules/skip/).

Also, use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/) to selectively enable or disable this feature for certain sections of your website using a filter expression (such as a matching hostname or request URL path).
