---
title: Traffic detections · Cloudflare Web Application Firewall (WAF) docs
description: Traffic detections check incoming requests for malicious or
  potentially malicious activity. Each enabled detection provides one or more
  scores — available in the Security Analytics dashboard — that you can use in
  rule expressions.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/
  md: https://developers.cloudflare.com/waf/detections/index.md
---

Traffic detections check incoming requests for malicious or potentially malicious activity. Each enabled detection provides one or more scores — available in the [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) dashboard — that you can use in rule expressions.

Cloudflare currently provides the following detections for finding security threats in incoming requests:

* [WAF attack score](https://developers.cloudflare.com/waf/detections/attack-score/)
* [Leaked credentials detection](https://developers.cloudflare.com/waf/detections/leaked-credentials/)
* [Malicious uploads detection](https://developers.cloudflare.com/waf/detections/malicious-uploads/)
* [Firewall for AI (beta)](https://developers.cloudflare.com/waf/detections/firewall-for-ai/)
* [Bot score](https://developers.cloudflare.com/bots/concepts/bot-score/)

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Malicious uploads detection | No | No | No | Paid add-on |
| Leaked credentials detection | Yes | Yes | Yes | Yes |
| Leaked credentials fields | Password Leaked | Password Leaked, User and Password Leaked | Password Leaked, User and Password Leaked | All leaked credentials fields |
| Number of custom detection locations | 0 | 0 | 0 | 10 |
| Attack score | No | No | One field only | Yes |
| Firewall for AI (beta) | No | No | No | Yes |

For more information on bot score, refer to the [Bots documentation](https://developers.cloudflare.com/bots/concepts/bot-score/).

## Turn on a detection

To turn on a traffic detection:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings**.
  3. Under **Incoming traffic detections**, turn on the desired detections.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Detections**.
  3. Turn on the desired detections.

Enabled detections will run for all incoming traffic.

Notes

On Free plans, the leaked credentials detection is enabled by default, and no action is required.

Currently, you cannot manage the [bot score](https://developers.cloudflare.com/bots/concepts/bot-score/) and [attack score](https://developers.cloudflare.com/waf/detections/attack-score/) detections from the **Settings** page. Refer to the documentation of each feature for availability details.

## More resources

For more information on detection versus mitigation, refer to [Concepts](https://developers.cloudflare.com/waf/concepts/#detection-versus-mitigation).
