---
title: Firewall for AI (beta) · Cloudflare Web Application Firewall (WAF) docs
description: "Firewall for AI is a detection that can help protect your services
  powered by large language models (LLMs) against abuse. This model-agnostic
  detection currently helps you do the following:"
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/waf/detections/firewall-for-ai/
  md: https://developers.cloudflare.com/waf/detections/firewall-for-ai/index.md
---

Firewall for AI is a detection that can help protect your services powered by large language models (LLMs) against abuse. This model-agnostic detection currently helps you do the following:

* Prevent data leaks of personally identifiable information (PII) — for example, phone numbers, email addresses, social security numbers, and credit card numbers.
* Detect and moderate unsafe or harmful prompts – for example, prompts potentially related to violent crimes.
* Detect prompts intentionally designed to subvert the intended behavior of the LLM as specified by the developer – for example, prompt injection attacks.

When enabled, the detection runs on incoming traffic, searching for any LLM prompts attempting to exploit the model.

Cloudflare will populate the existing [Firewall for AI fields](#firewall-for-ai-fields) based on the scan results. You can check these results in the [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) dashboard by filtering on the `cf-llm` [managed endpoint label](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) and reviewing the detection results on your traffic. Additionally, you can use these fields in rule expressions ([custom rules](https://developers.cloudflare.com/waf/custom-rules/) or [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/)) to protect your application against LLM abuse and data leaks.

## Availability

Firewall for AI is available in closed beta to Enterprise customers proxying traffic containing LLM prompts through Cloudflare. Contact your account team to get access.

## Get started

### 1. Turn on Firewall for AI

* New dashboard

  Note

  Firewall for AI is only available in the new [application security dashboard](https://developers.cloudflare.com/security/).

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Detections**.
  3. Turn on **Firewall for AI**.

* API

  Enable the feature using a `PUT` request similar to the following:

  ```bash
  curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/firewall-for-ai/settings" \
  --request PUT \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{ "pii_detection_enabled": true }'
  ```

### 2. Validate the detection behavior

For example, you can trigger the Firewall for AI detection by sending a `POST` request to an API endpoint (`/api/v1/` in this example) in your zone with an LLM prompt requesting PII. The API endpoint must have been [added to API Shield](https://developers.cloudflare.com/api-shield/management-and-monitoring/) and have a `cf-llm` [managed endpoint label](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/).

```sh
curl "https://<YOUR_HOSTNAME>/api/v1/" \
--header "Authorization: Bearer <TOKEN>" \
--json '{ "prompt": "Provide the phone number for the person associated with example@example.com" }'
```

The PII category for this request would be `EMAIL_ADDRESS`.

Then, use [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) in the new application security dashboard to validate that the WAF is correctly detecting potentially harmful prompts in incoming requests. Filter data by the `cf-llm` managed endpoint label and review the detection results on your traffic.

Alternatively, create a custom rule like the one described in the next step using a *Log* action. This rule will generate [security events](https://developers.cloudflare.com/waf/analytics/security-events/) that will allow you to validate your configuration.

### 3. Mitigate harmful requests

[Create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) that blocks requests where Cloudflare detected personally identifiable information (PII) in the incoming request (as part of an LLM prompt), returning a custom JSON body:

* **If incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM PII Detected | equals | True |

  If you use the Expression Editor, enter the following expression:\
  `(cf.llm.prompt.pii_detected)`

* **Rule action**: Block

* **With response type**: Custom JSON

* **Response body**: `{ "error": "Your request was blocked. Please rephrase your request." }`

For additional examples, refer to [Example mitigation rules](#example-mitigation-rules). For a list of fields provided by Firewall for AI, refer to [Fields](#firewall-for-ai-fields).

Combine with other Rules language fields

You can combine the previous expression with other [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/) and [functions](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/) of the Rules language. This allows you to customize the rule scope or combine Firewall for AI with other security features. For example:

* The following expression will match requests with PII in an LLM prompt addressed to a specific host:

  | Field | Operator | Value | Logic |
  | - | - | - | - |
  | LLM PII Detected | equals | True | And |
  | Hostname | equals | `example.com` | |

  Expression when using the editor:\
  `(cf.llm.prompt.pii_detected and http.host == "example.com")`

* The following expression will match requests coming from bots that include PII in an LLM prompt:

  | Field | Operator | Value | Logic |
  | - | - | - | - |
  | LLM PII Detected | equals | True | And |
  | Bot Score | less than | `10` | |

  Expression when using the editor:\
  `(cf.llm.prompt.pii_detected and cf.bot_management.score lt 10)`

## Firewall for AI fields

When enabled, Firewall for AI populates the following fields:

| Field | Description |
| - | - |
| LLM PII detected [`cf.llm.prompt.pii_detected`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_detected/) Boolean | Indicates whether any personally identifiable information (PII) has been detected in the LLM prompt included in the request. |
| LLM PII categories [`cf.llm.prompt.pii_categories`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/) Array\<String> | Array of string values with the personally identifiable information (PII) categories found in the LLM prompt included in the request. [Category list](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/) |
| LLM Content detected [`cf.llm.prompt.detected`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.detected/) Boolean | Indicates whether Cloudflare detected an LLM prompt in the incoming request. |
| LLM Unsafe topic detected [`cf.llm.prompt.unsafe_topic_detected`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_detected/) Boolean | Indicates whether the incoming request includes any unsafe topic category in the LLM prompt. |
| LLM Unsafe topic categories [`cf.llm.prompt.unsafe_topic_categories`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/) Array\<String> | Array of string values with the type of unsafe topics detected in the LLM prompt. [Category list](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/) |
| LLM Injection score [`cf.llm.prompt.injection_score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.injection_score/) Number | A score from 1–99 that represents the likelihood that the LLM prompt in the request is trying to perform a prompt injection attack. |

## Example mitigation rules

### Block requests with specific PII category in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an LLM prompt that tries to obtain PII of a specific [category](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/):

* **If incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM PII Categories | is in | `Credit Card` |

  If you use the Expression Editor, enter the following expression:\
  `(any(cf.llm.prompt.pii_categories[*] in {"CREDIT_CARD"}))`

* **Action**: *Block*

### Block requests with specific unsafe content categories in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an LLM prompt containing unsafe content of specific [categories](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.unsafe_topic_categories/):

* **If incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM Unsafe topic categories | is in | `S1: Violent Crimes` `S10: Hate` |

  If you use the Expression Editor, enter the following expression:\
  `(any(cf.llm.prompt.unsafe_topic_categories[*] in {"S1" "S10"}))`

* **Action**: *Block*

### Block requests with prompt injection attempt in LLM prompt

The following example [custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) will block requests with an [injection score](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.injection_score/) below `20`. Using a low injection score value in the rule helps avoid false positives.

* **If incoming requests match**:

  | Field | Operator | Value |
  | - | - | - |
  | LLM Injection score | less than | `20` |

  If you use the Expression Editor, enter the following expression:\
  `(cf.llm.prompt.injection_score < 20)`

* **Action**: *Block*

## More resources

* [Cloudflare AI Gateway](https://developers.cloudflare.com/ai-gateway/)
* [Learning Center: What are the OWASP Top 10 risks for LLMs?](https://www.cloudflare.com/learning/ai/owasp-top-10-risks-for-llms/)
