---
title: Flexible - SSL/TLS encryption modes · Cloudflare SSL/TLS docs
description: Traffic from browsers to Cloudflare can be encrypted via HTTPS, but
  traffic from Cloudflare to the origin server is not. This mode is common for
  origins that do not support TLS, though upgrading the origin configuration is
  recommended whenever possible.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/flexible/
  md: https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/flexible/index.md
---

Setting your encryption mode to **Flexible** makes your site partially secure. Cloudflare allows HTTPS connections between your visitor and Cloudflare, but all connections between Cloudflare and your origin are made through HTTP. As a result, an SSL certificate is not required on your origin.

```mermaid
flowchart LR
    accTitle: Flexible SSL/TLS Encryption
    accDescr: With an encryption mode of Flexible, your application encrypts traffic between the visitor and Cloudflare, but not between Cloudflare and your server.
    A[Browser] <--Encrypted--> B((Cloudflare))<--Unencrypted--> C[(Origin server)]
```

## Use when

Choose this option when you cannot set up an SSL certificate on your origin or your origin does not support SSL/TLS.

## Required setup

### Prerequisites

Depending on your origin configuration, you may have to adjust settings to avoid [Mixed Content errors](https://developers.cloudflare.com/ssl/troubleshooting/mixed-content-errors/) or [redirect loops](https://developers.cloudflare.com/ssl/troubleshooting/too-many-redirects/).

### Process

* Dashboard

  To change your encryption mode in the dashboard:

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account and domain.
  2. Go to **SSL/TLS**.
  3. Choose an encryption mode.

* API

  To adjust your encryption mode with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ssl` as the setting name in the URI path, and the `value` parameter set to your desired setting (`off`, `flexible`, `full`, `strict`, or `origin_pull`).

## Limitations

Flexible mode is only supported for HTTPS connections on port 443 (default port). Other ports using HTTPS will fall back to [**Full** mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full/).

If your application contains sensitive information (personalized data, user login), use [**Full**](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full/) or [**Full (Strict)**](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/full-strict/) modes instead.

[Authenticated Origin Pull](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/) does not work when your [**SSL/TLS encryption mode**](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/) is set to **Off** or **Flexible**.

