---
title: Security Insights · Cloudflare Security Center docs
description: "Security Insights provides you with a list of insights, covering
  different areas of your Cloudflare environment, such as: Cloudflare account
  settings, DNS record configurations, SSL/TLS certificates configurations,
  Cloudflare Access configurations and Cloudflare WAF configurations."
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/security-insights/
  md: https://developers.cloudflare.com/security-center/security-insights/index.md
---

User permission

Ensure your user has one of the necessary roles to access Security Insights. Refer to [Roles and permissions](https://developers.cloudflare.com/security-center/security-insights/roles-and-permissions/) for more information.

Security Insights provides you with a list of insights, covering different areas of your Cloudflare environment, such as: Cloudflare account settings, DNS record configurations, SSL/TLS certificates configurations, Cloudflare Access configurations and Cloudflare WAF configurations.

Listed below are the specific insights currently available:

| Insight Name | Description |
| - | - |
| [CASB integration status](https://developers.cloudflare.com/cloudflare-one/applications/casb/troubleshooting/) | We detect unhealthy CASB integrations. |
| [Dangling `A` Records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) | A record is pointing to an IPv4 address that you might no longer control. You are at risk of a subdomain takeover. |
| [Dangling `AAAA` Records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) | A record is pointing to an IPv6 address that you might no longer control. You are at risk of a subdomain takeover. |
| [Dangling `CNAME` Records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) | A record is pointing to a resource that cannot be found. You are at risk of a subdomain takeover. |
| [DMARC Record Errors](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#dmarc) | We detect an incorrect or missing `DMARC` record. |
| [Domains missing TLS Encryption](https://developers.cloudflare.com/ssl/get-started/) | We detect that there is no TLS encryption for this domain. |
| [Domains supporting older TLS version](https://developers.cloudflare.com/ssl/reference/protocols/) | This domain supports older versions of the TLS protocol. |
| [Domains without 'Always Use HTTPS'](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/) | HTTP requests to this domain may not redirect to its HTTPS equivalent. |
| [Domains without HSTS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/http-strict-transport-security/) | HTTP Strict Transport Security (`HSTS`), is a header which allows a website to specify and enforce security policy in client web browsers. This policy enforcement protects secure websites from downgrade attacks SSL stripping and cookie hijacking. |
| [Exposed RDP Servers](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/use-cases/rdp/) | We detect an RDP server that is exposed to the public Internet. |
| [Get notified of malicious client-side scripts](https://developers.cloudflare.com/page-shield/alerts/) | We detect that Page Shield alerts are not configured. You will not receive notifications when we detect potential malicious scripts executing in your client-side environment. |
| [Increased body response size detected on API endpoints](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) | Investigate changes, abuse, or successful attacks that may have led to this increase in response body size. |
| [Increased errors detected on API endpoints](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) | Investigate changes, abuse, or successful attacks that may have led to this increase in errors. |
| [Increased latency detected on API endpoints](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) | Investigate changes, abuse, or successful attacks that may have led to this increase in response latency. |
| [Managed Rules not deployed](https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/) | No managed rules deployed on a WAF protected domain. |
| [Upgrade to new Managed Rules](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/upgrade/) | Upgrade to new Managed Rules system required for optimal protection. |
| [Mixed-authentication API endpoints detected](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/#managed-labels) | Not all of the successful requests against API endpoints carried session identifiers. |
| [New API endpoints detected](https://developers.cloudflare.com/api-shield/security/api-discovery/) | API Discovery detects new API endpoints in your zone's traffic. |
| [New CASB integrations found](https://developers.cloudflare.com/cloudflare-one/applications/casb/casb-integrations/) | New CASB integrations have been found. |
| [Overprovisioned Access Policies](https://developers.cloudflare.com/cloudflare-one/policies/access/) | We detect an Access policy to allow everyone access to your application. |
| [Page Shield not enabled](https://developers.cloudflare.com/page-shield/get-started/) | Page Shield helps meet PCI DSS v4.0 compliance regarding requirement 6.4.3. |
| [SPF Record Errors](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#spf) | We detect an incorrect or missing `SPF` record. |
| [Schema Validation missing from eligible API endpoints](https://developers.cloudflare.com/api-shield/security/schema-validation/) | Apply the learned schema to protect your API against fuzzing attacks. |
| [Sensitive data in API response](https://developers.cloudflare.com/api-shield/management-and-monitoring/#sensitive-data-detection) | Sensitive data in API responses detected. |
| [Turn on JavaScript Detection](https://developers.cloudflare.com/bots/additional-configurations/javascript-detections/) | One or more of your Bot Management enabled zones does not have JavaScript Detection enabled, which is a critical part of our bot detection suite. |
| [Unassigned Access seats](https://developers.cloudflare.com/cloudflare-one/) | We detect a Zero Trust subscription that is not configured yet. |
| [Unauthenticated API endpoints detected](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/#managed-labels) | None of the successful requests against API endpoints carried session identifiers. |
| [Unprotected Cloudflare Tunnels](https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/#4-connect-your-origin-to-cloudflare) | We detect an application that is served by a Cloudflare Tunnel but not protected by a corresponding Access policy. |
| [Unproxied `A` Records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) | This DNS record is not proxied by Cloudflare. Cloudflare can not protect this origin because it is exposed to the public Internet. |
| [Unproxied `AAAA` Records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) | This DNS record is not proxied by Cloudflare. Cloudflare can not protect this origin because it is exposed to the public Internet. |
| [Unproxied `CNAME` Records](https://developers.cloudflare.com/dns/proxy-status/#dns-only-records) | This DNS record is not proxied by Cloudflare. Cloudflare can not protect this origin because it is exposed to the public Internet. |
| [Users without MFA](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/) | We detect that a Cloudflare administrative user has not enabled multifactor authentication. |
| [Zones without WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/) | We detect that this domain does not have the WAF's Managed Rules enabled. You are at risk from zero-day and other common vulnerabilities. |
| [No Turnstile enabled](https://developers.cloudflare.com/turnstile/) | We detect that there is no Turnstile widget configured on the account. |

For more information on available operations for Security Insights, refer to [Review Security Insights](https://developers.cloudflare.com/security-center/security-insights/review-insights/).
