---
title: cf.llm.prompt.pii_categories · Cloudflare Ruleset Engine docs
description: Array of string values with the personally identifiable information
  (PII) categories found in the LLM prompt included in the request.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.llm.prompt.pii_categories/index.md
---

# cf.llm.prompt.pii\_categories

`cf.llm.prompt.pii_categories` Array\<String>

Array of string values with the personally identifiable information (PII) categories found in the LLM prompt included in the request.

The possible values are the following:

| Category | Description |
| - | - |
| `CREDIT_CARD` | Credit card number |
| `CRYPTO` | Crypto wallet number (currently only Bitcoin address) |
| `DATE_TIME` | Absolute or relative dates or periods or times smaller than a day |
| `EMAIL_ADDRESS` | Email address |
| `IBAN_CODE` | International Bank Account Number (IBAN) |
| `IP_ADDRESS` | Internet Protocol (IP) address |
| `NRP` | A person's nationality, religious or political group |
| `LOCATION` | Name of politically or geographically defined location (cities, provinces, countries, international regions, bodies of water, mountains) |
| `PERSON` | Full person name |
| `PHONE_NUMBER` | Telephone number |
| `MEDICAL_LICENSE` | Common medical license numbers |
| `URL` | Uniform Resource Locator (URL), used to locate a resource on the Internet |
| `US_BANK_NUMBER` | US bank account number |
| `US_DRIVER_LICENSE` | US driver license |
| `US_ITIN` | US Individual Taxpayer Identification Number (ITIN) |
| `US_PASSPORT` | US passport number |
| `US_SSN` | US Social Security Number (SSN) |
| `UK_NHS` | UK NHS number |
| `UK_NINO` | UK National Insurance Number |
| `ES_NIF` | Spanish NIF number (personal tax ID) |
| `ES_NIE` | Spanish NIE number (foreigners ID card) |
| `IT_FISCAL_CODE` | Italian personal tax ID code |
| `IT_DRIVER_LICENSE` | Italian driver license number |
| `IT_VAT_CODE` | Italian VAT code number |
| `IT_PASSPORT` | Italian passport number |
| `IT_IDENTITY_CARD` | Italian identity card number |
| `PL_PESEL` | Polish PESEL number |
| `SG_NRIC_FIN` | National Registration Identification Card (Singapore) |
| `SG_UEN` | Unique Entity Number (for entities registered in Singapore) |
| `AU_ABN` | Australian Business Number (ABN) |
| `AU_ACN` | Australian Company Number (ACN) |
| `AU_TFN` | Australian tax file number (TFN) |
| `AU_MEDICARE` | Medicare number (issued by Australian government) |
| `IN_PAN` | Indian Permanent Account Number (PAN) |
| `IN_AADHAAR` | Individual identity number (issued by Indian government) |
| `IN_VEHICLE_REGISTRATION` | Vehicle registration number (issued by Indian government) |
| `IN_VOTER` | Numeric voter ID (issued by Indian Election Commission) |
| `IN_PASSPORT` | Indian Passport Number |
| `FI_PERSONAL_IDENTITY_CODE` | Finnish Personal Identity Code |

The categories list is based on the [list of PII entities supported by Presidio](https://microsoft.github.io/presidio/supported_entities/). Presidio is the data protection and de-identification SDK used in Firewall for AI.

Requires a Cloudflare Enterprise plan. You must also enable [Firewall for AI](https://developers.cloudflare.com/waf/detections/firewall-for-ai/).

Example usage:

```txt
# Matches requests where PII categorized as "EMAIL_ADDRESS" or "IBAN_CODE" was detected:
(cf.llm.prompt.pii_detected and any(cf.llm.prompt.pii_categories[*] in {"EMAIL_ADDRESS" "IBAN_CODE"}))
```

Categories:

* Request
