---
title: Extend Cloudflare's benefits to SaaS providers' end-customers ·
  Cloudflare Reference Architecture docs
description: Learn how to use Cloudflare to extend performance, security, and
  data localization to your end users.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/design-guides/extending-cloudflares-benefits-to-saas-providers-end-customers/
  md: https://developers.cloudflare.com/reference-architecture/design-guides/extending-cloudflares-benefits-to-saas-providers-end-customers/index.md
---

## Introduction

A key aspect of developing a Software-as-a-service (SaaS) application is ensuring its security against the wide array of potential attacks it faces on the Internet. Cloudflare's network and security services can be used to protect your customers using your SaaS application, off-loading the risk to a vendor with experience in [protecting applications](https://radar.cloudflare.com/reports/ddos).

This design guide illustrates how providers, building and hosting their own product/application offering, can leverage Cloudflare to extend the security, performance, and compliance benefits of Cloudflare's network to their end-customers.

The following diagrams visualize the use of the following services:

* Data Localization Suite (specifically, [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/))
* [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/)
* [Cloudflare Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) to securely expose web applications (with [public hostnames](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/) and [private networks](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/))
* Load Balancers to manage traffic and ensure reliability and performance, implementing Global Traffic Management (GTM) and [Private Network Load Balancing](https://developers.cloudflare.com/load-balancing/private-network/).

This setup is ideal for SaaS providers who need to ensure minimal downtime, auto-renewal of SSL/TLS certificates, efficiently distribute traffic to healthy endpoints, and regional traffic management for compliance and performance optimization.

This document assumes that the provider's application DNS is registered and managed through Cloudflare as the primary and authoritative DNS provider. You can find details on how to set this up in the [Cloudflare DNS Zone Setup Guide](https://developers.cloudflare.com/dns/zone-setups/full-setup/).

This solution supports subdomains under your own zone while also allowing your customers to use their own domain names (vanity or custom domains) with your services. For example, for each customer you may create the custom hostname `mycustomer.myappexample.com` but also want to allow them to use their own domain, `app.mycustomerexample.com` to point to their tenant on your service. Each subdomain (`mycustomer.myappexample.com`) can be created on the main domain (`myappexample.com`) through the [Cloudflare API](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/#create-dns-records), allowing you to easily automate the creation of DNS records when your customers create an account on your service.

## Benefits

Before looking at how Cloudflare can be configured to protect your SaaS application through your custom hostnames, it's worth reviewing the benefits of taking this approach.

| Benefit | Description |
| - | - |
| Minimized Downtime | Ensure [minimal downtime](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/issue-and-validate/validate-certificates/#minimize-downtime) not only during custom hostname migrations to Cloudflare for SaaS but also throughout the entire lifecycle of the application. |
| Security and Performance | Extends Cloudflare's [security](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/waf-for-saas/) and [performance](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/performance/) benefits to end-customers through their custom domains. |
| Auto-Renewal | Automates the [renewal](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/issue-and-validate/renew-certificates/) and management process for custom hostname certificates. |
| Apex Proxying | Supports end-customers using [domain apex](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/realtime-validation/#apex-proxying) (otherwise known as root domain) as custom hostnames. Used where your DNS service doesn't allow [CNAMEs for root domains](https://developers.cloudflare.com/dns/cname-flattening/), instead a [static IP](https://developers.cloudflare.com/byoip/address-maps/#static-ips-or-byoip) is used to allow an A record to be used. |
| Smart Load Balancing | Use the load balancer as [custom origins](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/) to steer traffic with [session affinity](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/). In the context of Cloudflare for SaaS, a custom origin lets you send traffic from one or more custom hostnames to somewhere besides your default proxy fallback origin. |
| Orange-to-Orange (O2O) | For end-customers who already proxy traffic through Cloudflare, [Orange-to-Orange (O2O)](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/saas-customers/how-it-works/) may be required. Generally, it's recommended for those end-customers to [not proxy](https://developers.cloudflare.com/dns/proxy-status/#dns-only-records) the hostnames used by the SaaS provider. If the Orange-to-Orange functionality is required, please review the [product compatibility](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/saas-customers/product-compatibility/). |
| Regional Services | Allows [regional traffic management](https://developers.cloudflare.com/data-localization/regional-services/) to comply with data localization requirements. |

## Products included in this guide

The following products are used to deliver this solution.

| Product | Function |
| - | - |
| [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) | Extends the security and performance benefits of Cloudflare’s network to your customers through their own custom or vanity domains. This includes [Certificate Management](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/), [WAF for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/waf-for-saas/), [Early Hints for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/performance/early-hints-for-saas/) and [Cache for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/performance/cache-for-saas/). |
| [DDoS Protection](https://developers.cloudflare.com/ddos-protection/) | Volumetric attack protection is automatically enabled for [proxied](https://developers.cloudflare.com/dns/proxy-status/) hostnames. |
| [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/) (part of the Data Localization Suite) | Restrict inspection of data (processing) to only those data centers within jurisdictional boundaries. |
| [Load Balancer](https://developers.cloudflare.com/load-balancing/) | Distributes traffic across your endpoints, which reduces endpoint strain and latency and improves the experience for end users. |
| [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) | Secure method to connect to customers' networks and servers without creating holes in [firewalls](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/tunnel-with-firewall/). cloudflared is the daemon (software) installed on origin servers to create a secure tunnel from applications back to Cloudflare. |

## Cloudflare for SaaS examples

The primary objective of using Cloudflare is to ensure that all requests to your application's custom hostname are routed through Cloudflare's security and performance services first to apply security controls and routing or load balancing of traffic. Since the origin server often needs to be publicly accessible, securing the connection between Cloudflare and the origin server is crucial. For comprehensive guidance on securing origin servers, please refer to Cloudflare's documentation: [Protect your origin server](https://developers.cloudflare.com/fundamentals/security/protect-your-origin-server/).

The diagrams below begin by illustrating the simplest approach to achieving this goal, followed by more complex configurations.

### Standard fallback origin setup

This standard Cloudflare for SaaS setup is the most commonly used and easiest to implement for most providers. Typically, these providers are SaaS companies, which develop and deliver software as a service solutions. This setup requires only a single DNS record to direct requests to Cloudflare, which then proxies the traffic to your application using an A record.

![Figure 1: Standard fallback origin setup.](https://developers.cloudflare.com/_astro/standard-fallback-origin-setup.DrGJNOUB_Z1el3om.svg)

1. The custom hostname (`custom.example.com`) is configured as a CNAME record pointing to the fallback origin of the provider. The fallback origin is the server or servers that Cloudflare will route traffic to by default when a request is made to the custom hostname. This DNS record does not need to be managed within Cloudflare; it just needs to point to the Cloudflare-hosted record from the provider (`fallback.myappexample.com`).
2. The Fallback Origin is set up as an A record that points to the public IP address of the origin server. Cloudflare will route traffic sent to the custom hostnames to this origin server by default.

The origin server receives the details of the custom domain through either the [host header or SNI](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/reference/connection-details/). This enables the origin server to determine which application to direct the request to. This method is applicable for both custom hostnames (for example, `app.mycustomerexample.com`) and vanity domains (for example, `customer1.myappexample.com`). Since all requests for your application are now routed through the Cloudflare network, you can leverage a range of security and performance services for every request, including:

* [Web Application Firewall](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/waf-for-saas/)
* [Access control policies](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/secure-with-access/)
* [Caching of application content](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/performance/cache-for-saas/)
* [Support browser early hints](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/performance/early-hints-for-saas/)
* [Image Transformations](https://developers.cloudflare.com/images/)
* [Waiting Room](https://developers.cloudflare.com/waiting-room/)
* [Workers for Platform](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

For implementation details to get started, review the [developer documentation](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/getting-started/).

### Standard fallback origin setup with regional services

This approach introduces using Cloudflare's [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/) solution to regionalize TLS termination and HTTP processing to confirm with any compliance regulations that dictate your service process data in specific geographic locations. This ensures that traffic destined for the origin server is handled exclusively within the chosen region.

![Figure 2: Standard fallback origin setup with regional services.](https://developers.cloudflare.com/_astro/standard-fallback-origin-setup-regional-services.DgKfyYv8_29Ja7E.svg)

1. The custom hostname (`custom.example.com`) is configured as a CNAME record that points to a regionalized SaaS hostname (`eu-customers.myappexample.com`). This configuration ensures that all processing, including TLS termination, occurs exclusively within the specified geographic region.
2. The regionalized SaaS hostname is set up as a CNAME record that directs traffic to the standard [Fallback Origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/getting-started/#1-create-fallback-origin) of the SaaS provider (`fallback.myappexample.com`).
3. The fallback origin is set up as an A record that points to the public IP address of the origin server. Cloudflare will route traffic sent to the custom hostnames to this origin server by default.

### Cloudflare Tunnel as fallback origin setup with regional services

For enhanced security, rather than exposing your application servers directly to the Internet via public IPs, SaaS providers can use [Cloudflare Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/). These tunnels connect your network to Cloudflare's nearest data centers, allowing SaaS applications to be accessed through [public hostnames](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/). As a result, Cloudflare becomes the sole entry point for end-customers from the public Internet into your application network.

![Figure 3: Cloudflare Tunnel as Fallback Origin Setup with Regional Services.](https://developers.cloudflare.com/_astro/cloudflare-tunnel-fallback-origin-setup-regional-services.h18fhKDd_Z1RlVxB.svg)

1. The custom hostname (`custom.example.com`) is configured as a CNAME record that points to a regionalized SaaS hostname (`eu-customers.myappexample.com`). This configuration ensures that all processing, including TLS termination, occurs exclusively within the specified geographic region.
2. The regionalized SaaS hostname is set up as a CNAME record that directs traffic to the standard [Fallback Origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/getting-started/#1-create-fallback-origin) of the SaaS provider (`fallback.myappexample.com`).
3. The fallback origin is a CNAME DNS record that points to a [public hostname](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/) exposed by Cloudflare Tunnel. This public hostname should be configured to route traffic to your application, for example, `localhost:8080`.

This setup is ideal for SaaS providers that do not need granular load balancing, such as [geo-based traffic steering](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/), across multiple origin servers. It's also well-suited for simple testing and development environments, where [protecting your origin server](https://developers.cloudflare.com/fundamentals/security/protect-your-origin-server/) by only allowing requests through the Cloudflare Tunnel is sufficient. However, for distributed applications requiring load balancing at both global and local levels, we recommend using [Cloudflare's Load Balancer](https://developers.cloudflare.com/load-balancing/) with global and private network load balancing capabilities.

### Global Traffic Management (GTM) & Private Network Load Balancing as custom origin setup

Cloudflare offers a powerful set of load balancing capabilities. These allow you to reliably steer traffic to different origin servers where your SaaS applications are hosted, whether through public hostnames (as described above) or private IP addresses. This setup helps prevent origin overload by distributing traffic across multiple servers and enhances security by only permitting requests through the Cloudflare Tunnel.

![Figure 4: Global Traffic Management (GTM) & Private Network Load Balancing as custom origin setup.](https://developers.cloudflare.com/_astro/gtm-ltm-custom-origin-setup.C_l8lMsz_2p0TxJ.svg)

1. The custom hostname (`custom.example.com`) is configured as a CNAME record pointing to a Cloudflare [regionalized Load Balancer](https://developers.cloudflare.com/data-localization/how-to/load-balancing/) (`eu-lb.myappexample.com`). This ensures that all processing, including TLS termination, takes place within a specified geographic region. Additionally, the SaaS provider needs to set up the load balancer as the [custom origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/) for the custom hostname.

2. The regional load balancer is set up with [origin pools](https://developers.cloudflare.com/load-balancing/pools/) to distribute requests across multiple downstream servers. Each pool can be configured to use either [public hostnames](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/) with Global Traffic Management (GTM) or [private network](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/) addresses with Private Network Load Balancing. In the diagram above, we utilize both options:

   * Origin pool 1 uses the [Cloudflare Tunnel hostname](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/dns/) (`<UUID>.cfargotunnel.com`) as the endpoint or origin server for handling those requests. When using a public hostname, it is necessary to set the [HTTP host header value](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/) to match the public hostname configured and exposed by the [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/). This ensures that the origin server can correctly route the incoming requests.
   * Origin pool 2 uses the private IP address or private network (that is, `10.0.0.5`) within the SaaS provider's internal network, where the SaaS application resides. This pool must be configured to operate within the specified [virtual network](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/) to ensure proper routing of requests.

3. Cloudflare Tunnel exposes both [public hostnames](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/routing-to-tunnel/) with GTM and [private networks](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/) (private IPs) with Private Network Load Balancing.

For enhanced granularity in application serving and scalability, it is generally recommended to use private networks rather than public hostnames. Private networks enable Cloudflare to preserve and accurately pass the host header to the origin server. In contrast, when using public hostnames, providers must configure the [header value](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/) on the load balancer, which is restricted to one public hostname per load balancer endpoint, potentially limiting flexibility.

Be aware of the Zero Trust [Tunnel limitations](https://developers.cloudflare.com/cloudflare-one/account-limits/#cloudflare-tunnel), Cloudflare for SaaS [connection request details](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/reference/connection-details/), and the Custom Origin [SNI specification](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/#sni-rewrites). For further information about the Cloudflare Load Balancer, review its [reference architecture](https://developers.cloudflare.com/reference-architecture/architectures/load-balancing/).

## Automation

As a SaaS provider, it is advisable to automate most, if not all, of these processes using [APIs](https://developers.cloudflare.com/fundamentals/api/), [SDKs](https://developers.cloudflare.com/fundamentals/api/reference/sdks/), scripts, [Terraform](https://developers.cloudflare.com/terraform/), or other automation tools.

An example of a high-level migration plan can be [downloaded here](https://developers.cloudflare.com/reference-architecture/static/example-cloudflare-saas-migration-plan.pdf).

It is highly recommended to migrate to Cloudflare for SaaS in phases and address any issues as they arise, particularly with [Domain Control Validation (DCV)](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/troubleshooting/). Be sure to review the [validation status](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/validation-status/) and relevant [documentation](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/) during the process.

## Summary

By leveraging Cloudflare's infrastructure, SaaS providers can deliver secure, reliable, and performance services to their end-customers. This ensures a seamless and secure user experience while meeting compliance requirements, such as regionalization.

Several Cloudflare customers are currently using the Cloudflare for SaaS solution (formerly known as SSL for SaaS). Notable public use cases include:

* [Shopify](https://www.cloudflare.com/case-studies/shopify/)
* [Porsche Informatik](https://www.cloudflare.com/case-studies/porsche-informatik/)
* [Divio](https://www.cloudflare.com/case-studies/divio/)
* [mogenius](https://www.cloudflare.com/case-studies/mogenius/)
* [Quickbutik](https://www.cloudflare.com/case-studies/quickbutik/)

Additionally, when migrating to Cloudflare for SaaS, it is crucial to have a runbook and clear public documentation to communicate relevant details to your end-customers. Excellent public examples of this are the [Salesforce CDN](https://help.salesforce.com/s/articleView?id=sf.community_builder_cdn.htm\&type=5) and [Shopify](https://help.shopify.com/en/manual/domains/add-a-domain/connecting-domains) documentation.
