---
title: Tutorials · Cloudflare R2 docs
description: View tutorials to help you get started with R2.
lastUpdated: 2025-08-14T13:46:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/r2/tutorials/
  md: https://developers.cloudflare.com/r2/tutorials/index.md
---

View tutorials to help you get started with R2.

## Docs

| Name | Last Updated | Type | Difficulty |
| - | - | - | - |
| [Point to R2 bucket with a custom domain](https://developers.cloudflare.com/rules/origin-rules/tutorials/point-to-r2-bucket-with-custom-domain/) | 6 months ago | 📝 Tutorial | Beginner |
| [Use event notification to summarize PDF files on upload](https://developers.cloudflare.com/r2/tutorials/summarize-pdf/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Use SSE-C](https://developers.cloudflare.com/r2/examples/ssec/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Use R2 as static asset storage with Cloudflare Pages](https://developers.cloudflare.com/pages/tutorials/use-r2-as-static-asset-storage-for-pages/) | about 1 year ago | 📝 Tutorial | Intermediate |
| [Create a fine-tuned OpenAI model with R2](https://developers.cloudflare.com/workers/tutorials/create-finetuned-chatgpt-ai-models-with-r2/) | over 1 year ago | 📝 Tutorial | Intermediate |
| [Protect an R2 Bucket with Cloudflare Access](https://developers.cloudflare.com/r2/tutorials/cloudflare-access/) | over 1 year ago | 📝 Tutorial | |
| [Log and store upload events in R2 with event notifications](https://developers.cloudflare.com/r2/tutorials/upload-logs-event-notifications/) | over 1 year ago | 📝 Tutorial | Beginner |
| [Use Cloudflare R2 as a Zero Trust log destination](https://developers.cloudflare.com/cloudflare-one/tutorials/r2-logs/) | almost 2 years ago | 📝 Tutorial | Beginner |
| [Deploy a Browser Rendering Worker with Durable Objects](https://developers.cloudflare.com/browser-rendering/workers-bindings/browser-rendering-with-do/) | about 2 years ago | 📝 Tutorial | Beginner |
| [Build an end to end data pipeline](https://developers.cloudflare.com/r2-sql/tutorials/end-to-end-pipeline/) | | 📝 Tutorial | |
| [Securely access and upload assets with Cloudflare R2](https://developers.cloudflare.com/workers/tutorials/upload-assets-with-r2/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Mastodon](https://developers.cloudflare.com/r2/tutorials/mastodon/) | over 2 years ago | 📝 Tutorial | Beginner |
| [Postman](https://developers.cloudflare.com/r2/tutorials/postman/) | over 3 years ago | 📝 Tutorial | |

## Videos

Welcome to the Cloudflare Developer Channel

Welcome to the Cloudflare Developers YouTube channel. We've got tutorials and working demos and everything you need to level up your projects. Whether you're working on your next big thing or just dorking around with some side projects, we've got you covered! So why don't you come hang out, subscribe to our developer channel and together we'll build something awesome. You're gonna love it.

Optimize your AI App & fine-tune models (AI Gateway, R2)

In this workshop, Kristian Freeman, Cloudflare Developer Advocate, shows how to optimize your existing AI applications with Cloudflare AI Gateway, and how to finetune OpenAI models using R2.
