---
title: IPv6 compatibility · Cloudflare Network settings docs
description: Cloudflare enables IPv6 on all domains without requiring additional
  configuration or hardware (as long as your host provides IPv6 support).
lastUpdated: 2025-08-19T09:45:12.000Z
chatbotDeprioritize: false
tags: IPv6
source_url:
  html: https://developers.cloudflare.com/network/ipv6-compatibility/
  md: https://developers.cloudflare.com/network/ipv6-compatibility/index.md
---

Cloudflare enables IPv6 on all domains without requiring additional configuration or hardware (as long as your host provides IPv6 support).

When IPv6 compatibility is turned on, Cloudflare auto generates [`AAAA` DNS records](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#a-and-aaaa) to allow IPv6 clients to connect. On the other hand, when IPv6 compatibility is turned off, Cloudflare does not automatically generate and advertise `AAAA` DNS for the zone. Client software will determine whether to use IPv4 or IPv6 to connect to a hostname that supports both methods.

For [proxied DNS records](https://developers.cloudflare.com/dns/proxy-status/) that have both an IPv6 and IPv4 origin address, Cloudflare will prefer the IPv4 address when connecting to your origin server.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Can customize | No | No | No | Yes |

## Enable IPv6 compatibility

By default, IPv6 compatibility is turned on for your domain and will apply to all domains and subdomains covered by [proxied DNS records](https://developers.cloudflare.com/dns/proxy-status/).

Note

If you have signed up for Cloudflare through a [Cloudflare hosting partner](http://www.cloudflare.com/hosting-partners) or by use [partial setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/), IPv6 compatibility does not apply to your apex domain.

## Disable IPv6 compatibility

If your origin web server only understands IPv4 formatted IP addresses, non-Enterprise customers should [enable **Pseudo IPv4**](https://developers.cloudflare.com/network/pseudo-ipv4/).

Alternatively, customers with an Enterprise account can disable Cloudflare's IPv6 compatibility.

* Dashboard

  To turn off IPv6 compatibility in the dashboard:

  1. Log in to your [Cloudflare account](https://dash.cloudflare.com) and go to a specific domain.
  2. Go to **Network**.
  3. Turn off **IPv6 Compatibility**.

* API

  To disable IPv6 compatibility using the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `ipv6` as the setting name in the URI path, and the `value` parameter set to `"off"`.

Note

Even when IPv6 is disabled, domains may still receive IPv6 traffic (for example, via the Tor network). To completely disable all IPv6 traffic:

* Turn off [**Onion Routing**](https://developers.cloudflare.com/network/onion-routing/).
* Use a [WAF custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) to block `0:0:0:0:0:0:0:0/0` using the filter `ip.src in {::/0}`.

***

## Troubleshoot an IPv6 network issue

Provide the following information to [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/) if you experience issues with IPv6 connectivity:

* A [traceroute](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/#perform-a-traceroute) that demonstrates the IPv6 connection issues.
* The [Cloudflare data center serving your request](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/gathering-information-for-troubleshooting-sites/#identify-the-cloudflare-data-center-serving-your-request) when the IPv6 issues occur.
* Confirmation of whether [disabling IPv6 Compatibility](#disable-ipv6-compatibility) resolves the issue.
