---
title: Cloudflare Tunnel · Cloudflare Magic WAN docs
description: Magic WAN can be used together with Cloudflare Tunnel for easy
  access between your networks and applications.
lastUpdated: 2025-10-15T16:28:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-tunnel/
  md: https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-tunnel/index.md
---

Magic WAN can be used together with [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) for easy access between your networks and applications.

By default, TCP, UDP, and ICMP traffic routed through Magic WAN tunnels and destined to routes behind Cloudflare Tunnel will be proxied/filtered through [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/).

## Cloudflare Tunnel and Magic Networking Route interactions

[Private network routes](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/) are evaluated together across Cloudflare Tunnel and Magic Networking routing tables. If traffic matches either a Cloudflare Tunnel route (in any virtual network) or a Magic Networking route, then the matched route will determine the next-hop.

To design solutions where a destination IP may match both a Cloudflare Tunnel private network route and a Magic Networking route, consult your solutions engineer for guidance.

## Test `cloudflared` tunnel integration

To check if a `cloudflared` tunnel is working properly with your Magic WAN connection, open a browser from a host behind your customer premise equipment, and browse to the `cloudflared` tunnel endpoint.

For example, imagine you have a Cloudflare Tunnel set up with a private network CIDR of `10.1.2.3/32`, a static route defined in Magic WAN for `10.1.2.3/24`, and the device you are trying to connect to is a web server. You can test connectivity to the web server by using a browser to load `https://10.1.2.3`. If the page loads correctly, your Cloudflare Tunnel is working properly. In this scenario, you have overlapping routes defined for Cloudflare Tunnel and Magic WAN.

As mentioned above, if you have overlapping routes in your Magic WAN and Cloudflare Tunnel routing configurations, Cloudflare Tunnel will take precedence. This happens whenever a `cloudflared` tunnel CIDR matches a packet, regardless of prefix length. For example, a `cloudflared` tunnel with prefix `10.1.2.0/24` will take precedence over a static route configured to `10.1.2.4/32`, sending packets over a GRE tunnel.

For more information, refer to [Connect private networks](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/).

Run `traceroute`

Magic WAN clients connecting through [GRE](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/), [IPsec](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/), [CNI](https://developers.cloudflare.com/network-interconnect/) or [WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/) that want to perform a `traceroute` to an endpoint behind a [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) will need to change some settings to make the command useful. Refer to [Run `traceroute`](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/traceroute/) for more information.
