---
title: Magic WAN Network Analytics · Cloudflare Magic WAN docs
description: Magic WAN customers can view their real-time and historical network
  data in Network Analytics. Customers can see their network data in a time
  series that shows Magic WAN traffic (in packets or bytes) over time, and can
  filter the time series data by different types of packet characteristics.
lastUpdated: 2025-10-15T16:28:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/analytics/network-analytics/
  md: https://developers.cloudflare.com/magic-wan/analytics/network-analytics/index.md
---

Magic WAN customers can view their real-time and historical network data in Network Analytics. Customers can see their network data in a time series that shows Magic WAN traffic (in packets or bytes) over time, and can filter the time series data by different types of [packet](https://www.cloudflare.com/learning/network-layer/what-is-a-packet/) characteristics.

Data is aggregated over time intervals that vary based on your selected zoom level. For example, a daily view shows 24-hour averages, which can flatten out short-term traffic spikes. As a result, longer time intervals will display lower peak bandwidth values compared to more granular views like five-minute intervals.

Refer to [Network Analytics](https://developers.cloudflare.com/analytics/network-analytics/) documentation to learn more.

## Network traffic data filters

Magic WAN customers have increased visibility into the various traffic flows across Cloudflare One products including:

* Traffic ingressing to Cloudflare's network via WARP
* Traffic egressing Cloudflare's network via WARP
* Traffic egressing Cloudflare's network via Cloudflare Tunnel (cloudflared)

The complete list of filters includes:

* A list of your top tunnels by traffic volume.
* Traffic source and destination for type of traffic, on-ramps and off-ramps, IP addresses, and ports.
* Destination IP ranges and ASNs.
* Protocols and packet sizes.
* Samples of all GRE or IPsec tunnel traffic entering or leaving Cloudflare's network.
* Mitigations applied (such as DDoS and Magic Firewall) to traffic entering Cloudflare.

Refer below to [Access Magic Tunnel traffic analytics](#access-magic-tunnel-traffic-analytics) to learn how to access these filters.

## Access Magic Tunnel traffic analytics

1. Go to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account.

2. Select **Analytics & Logs** > **Network Analytics**.

3. In the **All Traffic** tab, scroll to **Top Insights** to access network traffic filters. By default, the dashboard shows five items, but you can display up to 25 items at once. Select the drop-down menu to make your change.

4. (Optional) Hover your mouse over one of the types of traffic. You can then choose to filter for that type of traffic, or exclude it from the results.

5. You can also apply filters to adjust the scope of information displayed. Scroll to **All traffic** > **Add filter**.

6. In the **New filter** popover, choose what type of data you want to display from the left dropdown menu, an operator from the middle dropdown menu, and an action from the right dropdown menu. For example:

   ```txt
   <DESTINATION_TUNNELS> | _equals_ | <NAME_OF_YOUR_TUNNEL>
   ```

   This lets you examine traffic from specific Source tunnels and/or Destination tunnels.

## Feature notes

* For Magic Transit customers, `Non-tunnel traffic` will often represent traffic from the public Internet or traffic via [CNIs](https://developers.cloudflare.com/network-interconnect/).

* For Magic WAN customers, `Non-tunnel traffic` refers to traffic outside of GRE or IPsec tunnels. This can include traffic from:

  * [WARP](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/)
  * [CNIs](https://developers.cloudflare.com/network-interconnect/)
  * Traffic destined for the public Internet via [Gateway](https://developers.cloudflare.com/cloudflare-one/policies/gateway/)
  * Traffic destined for applications behind [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/)

The label `Non-Tunnel traffic` is a placeholder, and more specific labels will be applied to this category of traffic in the near future.
