---
title: Best practices · Cloudflare Magic Firewall docs
description: By default, Magic Firewall permits all ingress traffic that has
  passed through Cloudflare's core DDoS mitigations. To proactively mitigate
  attacks and minimize your attack surface and leakage of attack traffic into
  your environment, we recommend implementing your Magic Firewall rules using
  the following guidelines.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/best-practices/
  md: https://developers.cloudflare.com/magic-firewall/best-practices/index.md
---

By default, Magic Firewall permits all ingress traffic that has passed through Cloudflare's core DDoS mitigations. To proactively mitigate attacks and minimize your attack surface and leakage of attack traffic into your environment, we recommend implementing your Magic Firewall rules using the following guidelines.

The best approach is to replicate your current ingress perimeter firewall rules in Magic Firewall. If you are unable to export your current perimeter firewall rules, contact your Implementation Manager for help translating the rules into Magic Firewall rules.

* [Minimal ruleset](https://developers.cloudflare.com/magic-firewall/best-practices/minimal-ruleset/)
* [Extended ruleset](https://developers.cloudflare.com/magic-firewall/best-practices/extended-ruleset/)
* [Magic Transit egress](https://developers.cloudflare.com/magic-firewall/best-practices/magic-transit-egress/)
