---
title: Set up private IPs with Tunnel · Cloudflare Load Balancing docs
description: Consider the following steps to learn how to configure Private
  Network Load Balancing solution, using Cloudflare Tunnel as the off-ramp to
  securely connect to your private or internal services.
lastUpdated: 2025-09-16T17:43:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/private-network/tunnels-setup/
  md: https://developers.cloudflare.com/load-balancing/private-network/tunnels-setup/index.md
---

Consider the following steps to learn how to configure Private Network Load Balancing solution, using [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/) as the off-ramp to securely connect to your private or internal services.

## 1. Configure a Cloudflare tunnel with an assigned virtual network

The specific configuration steps can vary depending on your infrastructure and services you are looking to connect. If you are not familiar with Cloudflare Tunnel, the pages linked on each step provide more guidance.

1. [Create a tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/get-started/create-remote-tunnel/#1-create-a-tunnel) to connect your data center to Cloudflare.
2. Create a [virtual network](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/) and assign it to the tunnel you configured in the previous steps.

* Dashboard

  To create a virtual network:

  1. Within the [Zero Trust dashboard](https://one.dash.cloudflare.com), go to **Settings** > **WARP Client** and find the **Virtual networks** setting.
  2. Select **Add new** or **Manage** > **Create virtual network** to create virtual networks.
  3. Define your virtual network name and select **Save**.

  To assign the virtual network to the tunnel:

  1. Go to **Networks** > **Tunnels**.
  2. Select the tunnel you created in the previous steps and select **Configure**.
  3. Go to the **CIDR** tab and select **Add a CIDR route**.
  4. Enter an IP range and select the virtual network under **Additional settings**.
  5. Select **Save**.

* cli

  To create a virtual network:

  ```sh
  cloudflared tunnel vnet add <VNET_NAME>
  ```

  To assign the virtual network to the tunnel:

  ```sh
  cloudflared tunnel route ip add --vnet <VNET_NAME> <IP_RANGE> <TUNNEL_NAME>
  ```

## 2. Configure Cloudflare Load Balancing

Once you have Cloudflare tunnels with associated virtual networks (VNets) configured, the VNets can be specified for each endpoint when you [create or edit a pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/#create-a-pool). This will enable Cloudflare load balancers to use the correct tunnel and securely reach the private IP endpoints.

The specific configuration will vary depending on your use case. Refer to the following steps to understand the workflow.

1. [Create the Load Balancing monitor](https://developers.cloudflare.com/load-balancing/monitors/create-monitor/) according to your needs.
2. [Create the pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/) specifying your private IP addresses and corresponding virtual networks.

Note

* Currently, Cloudflare does not support entering the same endpoint IP addresses more than once, even when using different virtual networks.
* All endpoints with private IPs must have `virtual_network_id` specified.

- Dashboard

  You can create a pool within the [load balancer workflow](https://developers.cloudflare.com/load-balancing/load-balancers/create-load-balancer/) or in the **Pools** tab:

  1. Go to **Load Balancing**.

  2. Select the **Pools** tab and then **Create pool**.

  3. For your pool, enter the following information:

     * A name (must be unique)
     * A description to provide more detail on the name
     * A choice for [**Endpoint Steering**](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/origin-level-steering/), which affects how your pool routes traffic to each endpoint

  4. For each endpoint, enter the following information:

     * A name (must be unique)
     * The endpoint address or associated hostname
     * (Optional) A [**Virtual Network**](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/cloudflared/tunnel-virtual-networks/). Required when the endpoint has a private IP address.
     * A [**Weight**](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/origin-level-steering/#weights)
     * (Optional) A [hostname](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/) by clicking **Add host header**
     * (Optional) The destination port to which the traffic will be served.

  Note

  If your endpoint is a website or application hosted on [Cloudflare Pages](https://developers.cloudflare.com/pages/), you will need to fill in the host header field with the project domain for it to resolve correctly.

  1. Repeat this process for additional endpoints in the pool.

  2. (Optional) Set up coordinates for [Proximity Steering](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/steering-policies/proximity-steering/) on the pool.

  3. On the pool, update the following information:

     * **Health Threshold**:

       The Health Threshold is the number of healthy endpoints for the pool as a whole to be considered *Healthy* and receive traffic based on pool order in a load balancer. Increasing this number makes the pool more reliable, but also more likely to become unhealthy.

     * **Monitor**: Attach a [monitor](https://developers.cloudflare.com/load-balancing/monitors/create-monitor/)

     * **Health Monitor Regions**: Choose whether to check pool health from [multiple locations](https://developers.cloudflare.com/load-balancing/monitors/#health-monitor-regions), which increases accuracy but can lead to probe traffic to your endpoint

     * **Pool Notifications**: You can set up new alerts - and view existing alerts - to be notified when pools are enabled or disabled, or pools or endpoints have changes in their [health status](https://developers.cloudflare.com/load-balancing/understand-basics/health-details/).

  4. When finished, select **Save**.

- API

  To get a list of your current virtual networks, use the [List virtual networks](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/virtual_networks/methods/list/) API operation.

  Enable virtual/private IP support by adding the `virtual_network_id` field to the origins in you API request. Refer to the [Cloudflare Load Balancer API documentation](https://developers.cloudflare.com/api/resources/load_balancers/subresources/pools/methods/create/) for more information on how to create a pool using the API.

  Consider the following example for updating an existing Load Balancer pool with a Virtual IP origin using cURL.

  Warning

  All origins with private IPs must have `virtual_network_id` specified.

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Load Balancing: Monitors and Pools Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/load_balancers/pools/$POOL_ID" \
    --request PATCH \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "origins": [
          {
              "name": "origin-1",
              "address": "10.0.0.1",
              "enabled": true,
              "weight": 1,
              "virtual_network_id": "a5624d4e-044a-4ff0-b3e1-e2465353d4b4"
          }
      ]
    }'
  ```

1. [Create the load balancer](https://developers.cloudflare.com/load-balancing/load-balancers/create-load-balancer/), specifying the pool and monitor you created in the previous steps, as well as the desired [global traffic steering policies](https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/steering-policies/) and [custom rules](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/).

Spectrum limitations

If you will use the load balancer with [Spectrum](https://developers.cloudflare.com/spectrum/), consider the applicable [limitations](https://developers.cloudflare.com/load-balancing/additional-options/spectrum/#limitations) on load balancing and monitoring options.
