---
title: Define Split Tunnel settings · Cloudflare Learning Paths
description: Split tunnel settings determine which traffic WARP does and does not proxy.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/split-tunnel-settings/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/split-tunnel-settings/index.md
---

Split tunnel settings determine which traffic WARP does and does not proxy.

WARP offers two different split tunnel modes:

* If you intend to send all internal and external destination traffic through Cloudflare's global network, opt for **Exclude IPs and domains** mode. This mode will proxy everything through the WARP tunnel with the exception of IPs and hosts defined explicitly within the Split Tunnel list.
* If you intend to only use WARP to proxy private destination traffic, you can operate in **Include IPs and domains** mode, in which you explicitly define which IP ranges and domains should be included in the WARP routing table.

## Update Split Tunnels mode

To change your Split Tunnels mode:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.

  2. Under **Device settings**, locate the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to modify and select **Configure**.

  3. Scroll down to **Split Tunnels**.

  4. (Optional) To view your existing Split Tunnel configuration, select **Manage**. You will see a list of the IPs and domains Cloudflare Zero Trust excludes or includes, depending on the mode you have selected. We recommend making a copy of your Split Tunnel entries, as they will revert to the default upon switching modes.

  5. Under **Split Tunnels**, choose a mode:

     * **Exclude IPs and domains** — (Default) All traffic will be sent to Cloudflare Gateway except for the IPs and domains you specify.
     * **Include IPs and Domains** — Only traffic destined to the IPs or domains you specify will be sent to Cloudflare Gateway. All other traffic will bypass Gateway and will no longer be filtered by your network or HTTP policies. In order to use certain features, you will need to manually add [Zero Trust domains](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-domains).

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Choose a [`cloudflare_zero_trust_device_default_profile`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_default_profile) or [`cloudflare_zero_trust_device_custom_profile`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_custom_profile) resource to modify, or [create a new device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/#create-a-new-profile).

  3. In your device profile, configure either the `exclude` or `include` argument. You cannot set both `exclude` and `include` in a given device profile.

     a. To manage Split Tunnel routes in **Exclude** mode, use the `exclude` argument:

     ```tf
     resource "cloudflare_zero_trust_device_custom_profile" "exclude_example" {
       account_id            = var.cloudflare_account_id
       name                  = "Custom profile in Split Tunnels Exclude mode"
       enabled               = true
       precedence            = 101
       service_mode_v2       = {mode = "warp"}
       match                 =  "identity.email == \"test@cloudflare.com\""


       exclude = [{
           address = "10.0.0.0/8"
           description = "Example route to exclude from WARP tunnel"
       }]
     }
     ```

     In this example, all traffic will be sent to Cloudflare Gateway except for traffic destined to `10.0.0.0/8`. To exclude the default IPs and domains recommended by Cloudflare, refer to [Add a route](#add-a-route).

     b. To manage Split Tunnel routes in **Include** mode, use the `include` argument:

     ```tf
     resource "cloudflare_zero_trust_device_custom_profile" "include_example" {
       account_id            = var.cloudflare_account_id
       name                  = "Custom profile in Split Tunnels Include mode"
       enabled               = true
       precedence            = 101
       service_mode_v2       = {mode = "warp"}
       match                 =  "identity.email == \"test@cloudflare.com\""


       include = [{
           address = "10.0.0.0/8"
           description = "Example route to include in WARP tunnel"
       }]
     }
     ```

     In this example, only traffic destined to `10.0.0.0/8` will be sent to Cloudflare Gateway.

All clients with this device profile will now switch to the new mode and its default route configuration. Next, [add](#add-a-route) or [remove](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#remove-a-route) routes from your Split Tunnel configuration.

## Add a route

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.

  2. Under **Device settings**, locate the [device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/) you would like to modify and select **Configure**.

  3. Under **Split Tunnels**, check whether your [Split Tunnels mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) is set to **Exclude** or **Include**.

  4. Select **Manage**.

  5. You can exclude or include routes based on either their IP address or domain. When possible we recommend adding an IP address instead of a domain. To learn about the consequences of adding a domain, refer to [Domain-based Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#domain-based-split-tunnels).

     * Add an IP

       To add an IP address to Split Tunnels:

       1. Select *IP Address*.
       2. Enter the IP address or CIDR you want to exclude or include.
       3. Select **Save destination**.

       Traffic to this IP address is now excluded or included from the WARP tunnel.

     * Add a domain

       To add a domain to Split Tunnels:

       1. Select *Domain*.
       2. Enter a [valid domain](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#valid-domains) to exclude or include.
       3. Select **Save destination**.
       4. (Optional) If your domain does not have a public DNS record, create a [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) entry to allow a private DNS server to handle domain resolution.

       When a user goes to the domain, the domain gets resolved according to your Local Domain Fallback configuration (either by Gateway or by your private DNS server). WARP Split Tunnels will then dynamically include or exclude the IP address returned in the DNS lookup.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Choose a [`cloudflare_zero_trust_device_default_profile`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_default_profile) or [`cloudflare_zero_trust_device_custom_profile`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_custom_profile) resource to modify, or [create a new device profile](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/device-profiles/#create-a-new-profile).

  3. (Optional) Create a list of split tunnel routes that you can reuse across multiple device profiles. For example, you can declare a local value in the same module as your device profiles:

     ```tf
     locals {
       global_exclude_list = [
         # Default Split Tunnel entries recommended by Cloudflare
         {
           address     = "ff05::/16"
         },
         {
           address     = "ff04::/16"
         },
         {
           address     = "ff03::/16"
         },
         {
           address     = "ff02::/16"
         },
         {
           address     = "ff01::/16"
         },
         {
           address     = "fe80::/10"
           description = "IPv6 Link Local"
         },
         {
           address     = "fd00::/8"
         },
         {
           address     = "255.255.255.255/32"
           description = "DHCP Broadcast"
         },
         {
           address     = "240.0.0.0/4"
         },
         {
           address     = "224.0.0.0/24"
         },
         {
           address     = "192.168.0.0/16"
         },
         {
           address     = "192.0.0.0/24"
         },
         {
           address     = "172.16.0.0/12"
         },
         {
           address     = "169.254.0.0/16"
           description = "DHCP Unspecified"
         },
         {
           address     = "100.64.0.0/10"
         },
         {
           address     = "10.0.0.0/8"
         }
       ]
     }
     ```

  4. In the device profile, exclude or include routes based on either their IP address or domain:

     ```tf
     resource "cloudflare_zero_trust_device_custom_profile" "example" {
       account_id            = var.cloudflare_account_id
       name                  = "Example custom profile with split tunnels"
       enabled               = true
       precedence            = 101
       service_mode_v2       = {mode = "warp"}
       match                 =  "identity.email == \"test@cloudflare.com\""


       exclude = concat(
         # Global entries
         local.global_exclude_list,


         # Profile-specific entries
         [
           {
             address = "192.0.2.0/24"
             description = "Example IP to exclude from WARP"
           },
           {
             host = "example.com"
             description = "Example domain to exclude from WARP"
           }
         ]
       )
     }
     ```

     When possible we recommend adding an IP address instead of a domain. To learn about the consequences of adding a domain, refer to [Domain-based Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#domain-based-split-tunnels).

* Add an IP

  To add an IP address to Split Tunnels:

  1. Select *IP Address*.
  2. Enter the IP address or CIDR you want to exclude or include.
  3. Select **Save destination**.

  Traffic to this IP address is now excluded or included from the WARP tunnel.

* Add a domain

  To add a domain to Split Tunnels:

  1. Select *Domain*.
  2. Enter a [valid domain](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#valid-domains) to exclude or include.
  3. Select **Save destination**.
  4. (Optional) If your domain does not have a public DNS record, create a [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) entry to allow a private DNS server to handle domain resolution.

  When a user goes to the domain, the domain gets resolved according to your Local Domain Fallback configuration (either by Gateway or by your private DNS server). WARP Split Tunnels will then dynamically include or exclude the IP address returned in the DNS lookup.

It may take up to 10 minutes for newly updated settings to propagate to devices.

We recommend keeping the Split Tunnels list short, as each entry takes time for the client to parse. In particular, domains are slower to action than IP addresses because they require on-the-fly IP lookups and routing table / local firewall changes. A shorter list will also make it easier to understand and debug your configuration. For information on device profile limits, refer to [Account limits](https://developers.cloudflare.com/cloudflare-one/account-limits/#warp).

## Configure Split Tunnels for private network access

By default, WARP excludes traffic bound for [RFC 1918 space](https://datatracker.ietf.org/doc/html/rfc1918), which are IP addresses typically used in private networks and not reachable from the Internet. In order for WARP to send traffic to your private network, you must configure [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) so that the IP/CIDR of your private network routes through WARP.

1. First, check whether your [Split Tunnels mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode) is set to **Exclude** or **Include** mode.

2. Edit your Split Tunnel routes depending on the mode:

   * Exclude IPs and domains

     If you are using **Exclude** mode:

     a. [Delete the route](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#remove-a-route) containing your private network's IP/CIDR range. For example, if your network uses the default AWS range of `172.31.0.0/16`, delete `172.16.0.0/12`.

     b. [Re-add IP/CIDR ranges](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) that are not explicitly used by your private network. For the AWS example above, you would add new entries for `172.16.0.0/13`, `172.24.0.0/14`, `172.28.0.0/15`, and `172.30.0.0/16`. This ensures that only traffic to `172.31.0.0/16` routes through WARP.

     You can use the following calculator to determine which IP addresses to re-add:

     Calculator instructions

     1. In **Base CIDR**, enter the RFC 1918 range that you deleted from Split Tunnels.
     2. In **Excluded CIDRs**, enter the IP/CIDR range used by your private network.
     3. Re-add the calculator results to your Split Tunnel Exclude mode list.

     By tightening the private IP range included in WARP, you reduce the risk of breaking a user's [access to local resources](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-settings/#allow-users-to-enable-local-network-exclusion).

   * Include IPs and domains

     If you are using **Include** mode:

     1. Add the required [Zero Trust domains](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-domains) or [IP addresses](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-ip-addresses) to your Split Tunnel include list.
     2. [Add a route](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to include your private network's IP/CIDR range.
