---
title: Auditor · Cloudflare Key Transparency Auditor docs
description: The Auditor is designed to sign epoch information, which includes
  the time at which the request is received by the Auditor, the epoch number,
  and the epoch digest. The Auditor serializes this information in binary using
  protobuf or bincode and checks whether the requested inclusion is valid, as in
  it satisfies publication constraints.
lastUpdated: 2024-09-24T15:05:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/key-transparency/api/auditor-information/
  md: https://developers.cloudflare.com/key-transparency/api/auditor-information/index.md
---

The Auditor is designed to sign epoch information, which includes the time at which the request is received by the Auditor, the epoch number, and the epoch digest. The Auditor serializes this information in binary using protobuf or bincode and checks whether the requested inclusion is valid, as in it satisfies [publication constraints](https://developers.cloudflare.com/key-transparency/api/epochs/#constraints).

If the Log is setup to provide [AKD](https://github.com/facebook/akd) audit proof, the Auditor verifies them asynchronously.

## Get Auditor information

`keys` contain Auditor public keys which allow for key rotation later.

```sh
curl 'https://plexi.key-transparency.cloudflare.com/info'
{
  "keys": [
    {
      "public_key": "d1036a33a8731e82a29dc68210988b32b60b7c1bd22d2341f2e339f4db3a2f4a",
      "not_before": 1712311441501
    }
  ],
  "logs": [
    "508607faff7cb16be841e901eca41a6239461f239e7e610c9ea2576f334bc144"
  ]
}
```
