---
title: Delegate subdomains · Cloudflare DNS docs
description: Subdomain delegation allows different individuals, teams, or
  organizations to manage different subdomains of a site.
lastUpdated: 2025-02-13T13:23:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/manage-dns-records/how-to/subdomains-outside-cloudflare/
  md: https://developers.cloudflare.com/dns/manage-dns-records/how-to/subdomains-outside-cloudflare/index.md
---

Subdomain delegation allows different individuals, teams, or organizations to manage different subdomains of a site.

Note

DNS delegation is not possible for Cloudflare domains using a [partial setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup).

For instance, consider `example.com` as a Cloudflare domain with `www.example.com` managed in Cloudflare's **DNS** app and `internal.example.com` delegated to nameservers outside of Cloudflare. In this example, `internal.example.com` can now be managed by individuals who do not have access to Cloudflare credentials for the `example.com` domain.

Warning

Cloudflare's CDN and security services are not applied to delegated subdomains.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |

***

## Delegate a subdomain (outgoing)

To delegate a subdomain such as *internal.example.com*, tell DNS resolvers where to find the zone file:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.

2. Select the domain that contains the subdomain to be delegated.

3. Go to **DNS** > **Records**.

4. Create `NS` records for the subdomain. For example:

   * `internal.example.com NS ns1.externalhost.com`
   * `internal.example.com NS ns2.externalhost.com`
   * `internal.example.com NS ns3.externalhost.com`

   Note

   The `A` records for the subdomain are only required as glue records for nameservers that are located in the subdomain of the current zone that is being delegated.

5. (Optional) If the delegated nameserver has DNSSEC enabled, [add the `DS` record](https://developers.cloudflare.com/dns/dnssec/#1-activate-dnssec-in-cloudflare) in Cloudflare.

## Delegate a subdomain (incoming)

To delegate a subdomain from an external DNS provider to Cloudflare, refer to [subdomain setups](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/setup/).
