---
title: Zero Trust · Cloudflare Data Localization Suite docs
description: In the following sections, we will give you some details about how
  different Zero Trust products can be used with the Data Localization Suite.
lastUpdated: 2025-02-27T11:21:37.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/how-to/zero-trust/
  md: https://developers.cloudflare.com/data-localization/how-to/zero-trust/index.md
---

In the following sections, we will give you some details about how different Zero Trust products can be used with the Data Localization Suite.

## Gateway

Regional Services can be used with Gateway in all [supported regions](https://developers.cloudflare.com/data-localization/region-support/). Be aware that Regional Services only apply when using the WARP client in Gateway with WARP mode.

### Egress policies

Enterprise customers can purchase a [dedicated egress IP](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/dedicated-egress-ips/) (IPv4 and IPv6) or range of IPs geolocated to one or more Cloudflare network locations. This allows your egress traffic to geolocate to the city selected in your [egress policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/egress-policies/).

### HTTP policies

As part of Regional Services, Cloudflare Gateway will only perform [TLS decryption](https://developers.cloudflare.com/cloudflare-one/policies/gateway/http-policies/tls-decryption/) when using the [WARP client](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/) (in default [Gateway with WARP mode](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-modes/)).

#### Data Loss Prevention (DLP)

You are able to [log the payload of matched DLP rules](https://developers.cloudflare.com/cloudflare-one/policies/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules) and encrypt them with your public key so that only you can examine them later.

[Cloudflare cannot decrypt encrypted payloads](https://developers.cloudflare.com/cloudflare-one/policies/data-loss-prevention/dlp-policies/logging-options/#data-privacy).

### Network policies

You are able to [configure SSH proxy and command logs](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/ssh-logging/). Generate a Hybrid Public Key Encryption (HPKE) key pair and upload the public key `sshkey.pub` to your dashboard. All proxied SSH commands are immediately encrypted using this public key. The matching private key – which is in your possession – is required to view logs.

### DNS policies

Regional Services controls where Cloudflare decrypts traffic; because most DNS traffic is not encrypted, Gateway DNS cannot be regionalized using Regional Services.

Refer to the [WARP Settings](https://developers.cloudflare.com/data-localization/how-to/zero-trust/#warp-settings) section below for more information.

### Custom certificates

You can [bring your own certificate](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/user-side-certificates/custom-certificate/) to Gateway but these cannot yet be restricted to a specific region.

### Logs and Analytics

By default, Cloudflare will store and deliver logs from data centers across our global network. To maintain regional control over your data, you can use [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/) and restrict data storage to a specific geographic region. For more information refer to the section about [Logpush datasets supported](https://developers.cloudflare.com/data-localization/metadata-boundary/logpush-datasets/).

Customers also have the option to reduce the logs that Cloudflare stores:

* You can [exclude PII from logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/manage-pii/)
* You can [disable logging, or only log blocked requests](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/#selective-logging).

## Access

To ensure that all reverse proxy requests for applications protected by Cloudflare Access will only occur in FedRAMP-compliant data centers, you should use [Regional Services](https://developers.cloudflare.com/data-localization/regional-services/get-started/) with the region set to FedRAMP.

## Cloudflare Tunnel

You can [configure Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/cloudflared-parameters/run-parameters/#region) to only connect to data centers within the United States, regardless of where the software was deployed.

## WARP settings

### Local Domain Fallback

You can use the WARP setting [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/) in order to use a private DNS resolver, which you can manage yourself.

### Split Tunnels

[Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) allow you to decide which IP addresses/ranges and/or domains are routed through or excluded from Cloudflare.

Warning

Gateway policies will not apply for excluded traffic.
