---
title: Route traffic · Cloudflare Zero Trust docs
description: When the WARP client is deployed on a device, Cloudflare will
  process all DNS queries and network traffic by default. However, under certain
  circumstances, you may need to exclude specific DNS queries or network traffic
  from WARP. For example, you may need to resolve an internal hostname with a
  private DNS resolver instead of Cloudflare's public DNS resolver.
lastUpdated: 2025-08-12T14:28:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/
  md: https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/index.md
---

When the WARP client is deployed on a device, Cloudflare will process all DNS queries and network traffic by default. However, under certain circumstances, you may need to exclude specific DNS queries or network traffic from WARP. For example, you may need to resolve an internal hostname with a private DNS resolver instead of Cloudflare's [public DNS resolver](https://developers.cloudflare.com/1.1.1.1/).

Cloudflare recommends Enterprise users configure [Gateway resolver policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/resolver-policies/) to resolve traffic with custom resolvers. WARP will send private DNS queries to Gateway, then Gateway will send the queries to custom resolvers based on matching policies.

Additionally, there are three options you can configure to exclude traffic from WARP:

* [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/): Use Local Domain Fallback to instruct the WARP client to proxy DNS requests for a specified domain to a resolver that is not Cloudflare Gateway. This is useful when you have private hostnames that would not otherwise resolve on the public Internet.

  Warning

  Gateway will not encrypt, monitor, or apply DNS policies to DNS queries to domain names entered in Local Domain Fallback.

* [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) Exclude mode: Use Exclude mode to instruct the WARP client to ignore traffic to a specified set of IP addresses or domains. Any traffic that is destined to an IP address or domain defined in the Split Tunnels Exclude configuration will be ignored by the WARP client and handled by the local machine. Use this mode when you want the majority of your traffic encrypted and processed by Gateway, but need to exclude certain routes due to app compatibility, or if you need WARP to run alongside a VPN.

* [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/) Include mode: Use Include mode to instruct the WARP client to only handle traffic to a specified set of IP addresses or domains. Any traffic that is not included by an IP address or domain defined in the Split Tunnel Include configuration will be ignored by the WARP client and handled by the local machine. Use this mode when you only want specific traffic processed by Gateway, such as when using Tunnels for a specific resource.

  Warning

  Gateway will not encrypt, manage, or monitor traffic excluded from WARP by a Split Tunnel configuration.

## How the WARP client handles DNS requests

When you use the WARP client together with `cloudflared` Tunnels or third-party VPNs, Cloudflare evaluates each request and routes it according to the following traffic flow:

```mermaid
flowchart TD
    A["WARP user requests resource"] --> B["WARP client proxies all DNS traffic"]
    B -- WARP checks if domain is listed in Local Domain Fallback policies --> C["Local Domain Fallback"]

    %% Left branch (LDF exists)
    C -- Domain exists in Local Domain Fallback policies --> ST["Split Tunnel processing"]

    ST -- Resolver IP included in WARP Tunnel per Split Tunnel configuration --> QW["Query sent via WARP Tunnel to be resolved"]
    ST -- Resolver IP not included in WARP Tunnel per Split Tunnel configuration --> QO["Query sent to resolver IP outside WARP Tunnel"]

    QW -- Allowed by Gateway --> OR["Evaluated by Cloudflare on-ramp routes"]
    OR -- Onramp routes do not include resolver IP --> GP["Gateway proxies query to resolver IP via normal WARP egress route"]
    OR -- Onramp routes include, resolver IP --> ADV["Cloudflare onramps advertises route that includes Resolver IP"]
    ADV --> PR["Private resolver returns IP address to WARP client"]

    %% Right branch (no LDF match)
    C -- Domain does not exist in Local Domain Fallback policies --> GWR["Gateway checks Resolver Policies (Enterprise only)"]

    GWR -- Resolver policy is not matched --> C1111a["1.1.1.1"]

    GWR -- Resolver policy is matched --> IDNS["Internal DNS"]
    GWR -- Resolver policy is matched --> C1111b["1.1.1.1"]
    GWR -- Resolver policy is matched --> CUST["Custom resolver"]
    CUST --> PNS["Private network services<br>(Cloudflare Tunnel, Magic WAN, WARP Connector)"]
```

#### Terms mentioned

#### On-ramps (how traffic gets onto Cloudflare)

* On-ramp
* [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/)
* [WARP Connector](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/private-net/warp-connector/)
* [Magic WAN](https://developers.cloudflare.com/magic-wan/)

#### Routing features (how queries are handled)

* [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/)
* [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/split-tunnels/)
* [Gateway Resolver Policies](https://developers.cloudflare.com/cloudflare-one/policies/gateway/resolver-policies/)

#### Resolvers (where queries are resolved)

* [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/)
* [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/)

## Add a DNS suffix

Support for DNS suffix search lists in WARP is currently in development. You can manually configure DNS suffixes at the device level using the following instructions.

### macOS

To manually configure a DNS suffix on macOS:

1. Open **System Settings** (or **System Preferences** on older macOS versions).
2. Go to **Network** and select your active connection (**Wi-Fi** or **Ethernet**).
3. Select **Details** (or **Advanced**).
4. Go to the **DNS** tab.
5. Under **Search Domains**, select the `+` button and add your DNS suffix.
6. Select **OK**, then **Apply**.

### Windows

To manually configure a DNS suffix on Windows:

1. Open the **Search** bar in Windows, type **View network connections**, and select **Open**.
2. Right-click the network adapter (**Wi-Fi** or **Ethernet**) you want to modify and select **Properties**. (Admin privileges required.)
3. Double-click **Internet Protocol Version 4 (TCP/IPv4)**.
4. In the **Internet Protocol (TCP/IP) Properties** window, select **Advanced**.
5. Go to the **DNS** tab.
6. Select **Append these DNS suffixes (in order)**.
7. Select **Add**, enter your DNS suffix and select **Add**.
8. Select **OK** on all windows to apply changes.
