---
title: Publish a self-hosted application to the Internet · Cloudflare Zero Trust docs
description: You can securely publish internal tools and applications by adding
  Cloudflare Access as an authentication layer between the end user and your
  origin server.
lastUpdated: 2025-09-16T17:43:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/
  md: https://developers.cloudflare.com/cloudflare-one/applications/configure-apps/self-hosted-public-app/index.md
---

You can securely publish internal tools and applications by adding Cloudflare Access as an authentication layer between the end user and your origin server.

## Prerequisites

* An [active domain on Cloudflare](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/)
* Domain uses either a [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/) or a [partial (`CNAME`) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/)

## 1. Add your application to Access

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application**.

3. Select **Self-hosted**.

4. Enter any name for the application.

5. In **Session Duration**, choose how often the user's [application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/application-token/) should expire.

   Cloudflare checks every HTTP request to your application for a valid application token. If the user's application token (and global token) has expired, they will be prompted to reauthenticate with the IdP. For more information, refer to [Session management](https://developers.cloudflare.com/cloudflare-one/identity/users/session-management/).

1) Select **Add public hostname**.

2) In the **Domain** dropdown, select the domain that will represent the application. Domains must belong to an active zone in your Cloudflare account. You can use [wildcards](https://developers.cloudflare.com/cloudflare-one/policies/access/app-paths/) to protect multiple parts of an application that share a root path.

   Alternatively, to use a [Cloudflare for SaaS custom hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/secure-with-access/), set **Input method** to *Custom* and enter your custom hostname.

3) (Optional) Configure **Browser rendering settings**:

   * [Automatic `cloudflared` authentication](https://developers.cloudflare.com/cloudflare-one/applications/non-http/cloudflared-authentication/automatic-cloudflared-authentication/)
   * [Browser rendering for SSH, VNC, or RDP](https://developers.cloudflare.com/cloudflare-one/applications/non-http/browser-rendering/)

4) Add [Access policies](https://developers.cloudflare.com/cloudflare-one/policies/access/) to control who can connect to your application. All Access applications are deny by default -- a user must match an Allow policy before they are granted access.

5) Configure how users will authenticate:

   1. Select the [**Identity providers**](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/) you want to enable for your application.

   2. (Recommended) If you plan to only allow access via a single IdP, turn on **Instant Auth**. End users will not be shown the [Cloudflare Access login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/). Instead, Cloudflare will redirect users directly to your SSO login event.

   3. (Optional) Under **WARP authentication identity**, allow users to authenticate to the application using their [WARP session identity](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/warp-sessions/).

6) Select **Next**.

7) (Optional) Configure [App Launcher settings](https://developers.cloudflare.com/cloudflare-one/applications/app-launcher/) for the application.

8) Under **Block page**, choose what end users will see when they are denied access to the application:

   * **Cloudflare default**: Reload the [login page](https://developers.cloudflare.com/cloudflare-one/applications/login-page/) and display a block message below the Cloudflare Access logo. The default message is `That account does not have access`, or you can enter a custom message.
   * **Redirect URL**: Redirect to the specified website.
   * **Custom page template**: Display a [custom block page](https://developers.cloudflare.com/cloudflare-one/applications/block-page/) hosted in Zero Trust.

9) Select **Next**.

10) (Optional) Configure advanced settings:

    * [**Cross-Origin Resource Sharing (CORS) settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/cors/)
    * [**Cookie settings**](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/#cookie-settings)
    * **401 Response for Service Auth policies**: Return a `401` response code when a user (or machine) makes a request to the application without the correct [service token](https://developers.cloudflare.com/cloudflare-one/identity/service-tokens/).

11) Select **Save**.

## 2. Connect your origin to Cloudflare

[Set up a Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/get-started/create-remote-tunnel/) to publish your internal application. Only users who match your Access policies will be granted access.

Note

We recommend [creating an Access application](#1-add-your-application-to-access) before setting up the tunnel route. If you do not have an Access application in place, the published application will be available to anyone on the Internet.

If your application is already publicly routable, a Tunnel is not strictly required. However, you will then need to protect your origin IP using [other methods](https://developers.cloudflare.com/fundamentals/security/protect-your-origin-server/).

## 3. Validate the Access token

To secure your origin, you must validate the [application token](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/) issued by Cloudflare Access. Token validation ensures that any requests which bypass Cloudflare Access (for example, due to a network misconfiguration) are rejected.

One option is to configure the Cloudflare Tunnel daemon, `cloudflared`, to validate the token on your behalf. This is done by enabling [**Protect with Access**](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/cloudflared-parameters/origin-parameters/#access) in your Cloudflare Tunnel settings. Alternatively, if you do not wish to perform automatic validation with Cloudflare Tunnel, you can instead [manually configure your origin](https://developers.cloudflare.com/cloudflare-one/identity/authorization-cookie/validating-json/) to check all requests for a valid token.

Users can now connect to your self-hosted application after authenticating with Cloudflare Access.

## Product compatibility

When using Access self-hosted applications, the majority of Cloudflare products will be compatible with your application.

However, the following products are not supported:

* [Automatic Signed Exchanges](https://developers.cloudflare.com/speed/optimization/other/signed-exchanges/)
* [Automatic Platform Optimization](https://developers.cloudflare.com/automatic-platform-optimization)
* [Zaraz](https://developers.cloudflare.com/zaraz)

You can disable Automatic Signed Exchanges and Zaraz for a specific application - instead of across your entire zone - using a [Configuration Rule](https://developers.cloudflare.com/rules/configuration-rules/) scoped to the application domain.
