---
title: Improved Payload Logging for WAF Managed Rules · Changelog
description: We have upgraded WAF Payload Logging to enhance rule diagnostics and usability.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-08-improved-payload-logging/
  md: https://developers.cloudflare.com/changelog/2025-05-08-improved-payload-logging/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Improved Payload Logging for WAF Managed Rules

May 08, 2025

[WAF](https://developers.cloudflare.com/waf/)

We have upgraded WAF Payload Logging to enhance rule diagnostics and usability:

* **Targeted logging**: Logs now capture only the specific portions of requests that triggered WAF rules, rather than entire request segments.
* **Visual highlighting**: Matched content is visually highlighted in the UI for faster identification.
* **Enhanced context**: Logs now include surrounding context to make diagnostics more effective.

![Log entry showing payload logging details](https://developers.cloudflare.com/_astro/2025-05-payload-logging-update.1M29LjNm_Z29vw9H.webp)

Payload Logging is available to all Enterprise customers. If you have not used Payload Logging before, check how you can [get started](https://developers.cloudflare.com/waf/managed-rules/payload-logging/).

**Note:** The structure of the `encrypted_matched_data` field in Logpush has changed from `Map<Field, Value>` to `Map<Field, {Before: bytes, Content: Value, After: bytes}>`. If you rely on this field in your Logpush jobs, you should review and update your processing logic accordingly.
