---
title: Troubleshoot tunnels with diagnostic logs · Changelog
description: View tunnel diagnostic logs
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2024-12-19-diagnostic-logs/
  md: https://developers.cloudflare.com/changelog/2024-12-19-diagnostic-logs/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Troubleshoot tunnels with diagnostic logs

Dec 19, 2024

[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/)

The latest `cloudflared` build [2024.12.2](https://github.com/cloudflare/cloudflared/releases/tag/2024.12.2) introduces the ability to collect all the diagnostic logs needed to troubleshoot a `cloudflared` instance.

A diagnostic report collects data from a single instance of `cloudflared` running on the local machine and outputs it to a `cloudflared-diag` file.

The `cloudflared-diag-YYYY-MM-DDThh-mm-ss.zip` archive contains the files listed below. The data in a file either applies to the `cloudflared` instance being diagnosed (`diagnosee`) or the instance that triggered the diagnosis (`diagnoser`). For example, if your tunnel is running in a Docker container, the diagnosee is the Docker instance and the diagnoser is the host instance.

| File name | Description | Instance |
| - | - | - |
| `cli-configuration.json` | [Tunnel run parameters](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/configure-tunnels/cloudflared-parameters/run-parameters/) used when starting the tunnel | diagnosee |
| `cloudflared_logs.txt` | [Tunnel log file](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/logs/)[1](#user-content-fn-1) | diagnosee |
| `configuration.json` | Tunnel configuration parameters | diagnosee |
| `goroutine.pprof` | goroutine profile made available by `pprof` | diagnosee |
| `heap.pprof` | heap profile made available by `pprof` | diagnosee |
| `metrics.txt` | Snapshot of [Tunnel metrics](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/metrics/#available-metrics) at the time of diagnosis | diagnosee |
| `network.txt` | JSON traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
| `raw-network.txt` | Raw traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
| `systeminformation.json` | Operating system information and resource usage | diagnosee |
| `task-result.json` | Result of each diagnostic task | diagnoser |
| `tunnelstate.json` | Tunnel connections at the time of diagnosis | diagnosee |

## Footnotes

1. If the log file is blank, you may need to [set `--loglevel` to `debug`](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/monitor-tunnels/logs/#view-logs-on-the-server) when you start the tunnel. The `--loglevel` parameter is only required if you ran the tunnel from the CLI using a `cloudflared tunnel run` command. It is not necessary if the tunnel runs as a Linux/macOS service or runs in Docker/Kubernetes. [↩](#user-content-fnref-1)

For more information, refer to [Diagnostic logs](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/troubleshoot-tunnels/diag-logs/).
