---
title: Get started with Super Bot Fight Mode · Cloudflare bot solutions docs
description: "Super Bot Fight Mode is included in your Pro, Business, or
  Enterprise subscription. When enabled, the product:"
lastUpdated: 2025-10-15T15:50:02.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/
  md: https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/index.md
---

Super Bot Fight Mode is included in your Pro, Business, or Enterprise subscription. When enabled, the product:

* Identifies traffic matching patterns of known bots
* Can challenge or block bots
* Offers protection for static resources
* Provides limited analytics to help you understand bot traffic

Accounts with an Enterprise subscription but not the [Bot Management add-on](https://developers.cloudflare.com/bots/get-started/bot-management/) will have Super Bot Fight Mode for Business.

## Considerations

Bot Fight Mode and Super Bot Fight Mode use the same underlying technology that powers our [Bot Management](https://www.cloudflare.com/products/bot-management/) product. Specifically, these products:

* Protect entire domains without endpoint restrictions
* Cannot be customized, adjusted, or reconfigured via WAF custom rules

Although these products are designed to fight malicious actors on the Internet, they may challenge API or mobile app traffic. For more granular control, upgrade to [Bot Management for Enterprise](https://developers.cloudflare.com/bots/plans/bm-subscription/).

### WAF custom rules

[WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/) are executed before Super Bot Fight Mode.

This order has a critical impact on traffic processing. If a WAF custom rule performs a terminating action (such as *Block*, *Managed Challenge*, or *JS Challenge*), the request will not be processed further, and the Super Bot Fight Mode configuration will not be evaluated.

To configure exceptions to Super Bot Fight Mode, you should use the [*Skip* action in your WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/skip/). The *Skip* action allows the request to bypass the Super Bot Fight Mode phase without terminating the request, enabling it to continue through the rest of the security stack.

## Enable Super Bot Fight Mode

Note

If you are upgrading from Bot Fight Mode to Super Bot Fight Mode, you must disable Bot Fight Mode in your Bot settings.

Old dashboard: **Security** > **Bots**, and select **Configure Bot Fight Mode**.

New dashboard: **Security** > **Settings**. Filter by **Bot traffic** and turn **Bot Fight Mode** off.

To start using Super Bot Fight Mode:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login), and select your account and domain.

  2. Go to **Security** > **Bots**.

  3. Select **Configure Super Bot Fight Mode**.

  4. Choose how your domain should respond to various types of traffic:

     * For more details on verified bots, refer to [Verified Bots](https://developers.cloudflare.com/bots/concepts/bot/#verified-bots).
     * For more details on supported file types, refer to [Static resource protection](https://developers.cloudflare.com/bots/additional-configurations/static-resources/).
     * For more details on invisible code injection, refer to [JavaScript detections](https://developers.cloudflare.com/bots/additional-configurations/javascript-detections/).

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security Settings** page.

     [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/security/settings)

  2. Filter by **Bot traffic**.

  3. Go to **Super Bot Fight Mode**.

  4. Turn **Super Bot Fight Mode** on.

  5. Choose how your domain should respond to various types of traffic by selecting the associated edit icon:

     * For more details on verified bots, refer to [Verified Bots](https://developers.cloudflare.com/bots/concepts/bot/#verified-bots).
     * For more details on supported file types, refer to [Static resource protection](https://developers.cloudflare.com/bots/additional-configurations/static-resources/).
     * For more details on invisible code injection, refer to [JavaScript detections](https://developers.cloudflare.com/bots/additional-configurations/javascript-detections/).
     * For more details on WordPress optimization, refer to [Super Bot Fight Mode for WordPress](https://developers.cloudflare.com/bots/troubleshooting/wordpress-loopback-issue/).

Warning

If your organization also uses [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/), keep **Definitely Automated** set to **Allow**. Otherwise, tunnels might fail with a `websocket: bad handshake` error.

In parts of your site where you want bot traffic, you can use the [*Skip* action](https://developers.cloudflare.com/waf/custom-rules/skip/) in [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/) to specify where Super Bot Fight Mode should not run.

You can use the [Rules language](https://developers.cloudflare.com/ruleset-engine/rules-language/) and its [operators](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/) and [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/) in custom rules to configure a scoped rule for approved automated traffic in Super Bot Fight Mode.

***

## Disable Super Bot Fight Mode

If you find that **Super Bot Fight Mode** is causing problems with your application traffic, you may want to disable it.

To disable Super Bot Fight Mode:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login), and select your account and domain.
  2. Go to **Security** > **Bots**.
  3. Select **Configure Super Bot Fight Mode**.
  4. For all bot groupings (**Definitely automated**, **Verified bots**, etc.), set the value to **Allow**.
  5. For all other options (**Static resource protection**, **JavaScript Detections**), ensure they are off.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security Settings** page.

     [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/security/settings)

  2. Filter by **Bot traffic**.

  3. Go to **Super Bot Fight Mode**.

  4. Turn **Super Bot Fight Mode** off.

  5. For all bot groupings (**Definitely automated traffic**, **Verified bots**), select the edit icon and set the value to **Allow**.

  6. For all other options (**Static resource protection**, **JavaScript detections**, **Optimize for WordPress**), select the edit icon and ensure they are off.

In parts of your site where you want bot traffic, you can use the [*Skip* action](https://developers.cloudflare.com/waf/custom-rules/skip/) in [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/) to specify where Super Bot Fight Mode should not run.

You can use the [Rules language](https://developers.cloudflare.com/ruleset-engine/rules-language/) and its [operators](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/) and [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/) in custom rules to configure a scoped rule for approved automated traffic in Super Bot Fight Mode.

***

## Block AI bots

Refer to [Block AI bots](https://developers.cloudflare.com/bots/additional-configurations/block-ai-bots/).

Note

You can view blocked AI bot traffic via [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/).

***

## Analytics

### Bot Report

Use the **Bot Report** to monitor bot traffic for the past 24 hours.

To access the **Bot Report**, go to **Security** > **Bots**. If you see a double-digit percentage of automated traffic, you may want to upgrade to [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/) to save money on origin costs and protect your domain from large-scale attacks.

![Example traffic distribution as part of a bot report](https://developers.cloudflare.com/_astro/bot-report-pro.BU1S3xco_PCTRJ.webp)

### Security events

You can see bot-related actions by going to **Security** > **Events**. Any requests challenged by this product will be labeled **Super Bot Fight Mode** in the **Service** field. This allows you to observe, analyze, and follow trends in your bot traffic over time.

***

## Ruleset Engine

Super Bot Fight Mode runs during the `http_request_sbfm` phase of the [Ruleset Engine](https://developers.cloudflare.com/ruleset-engine/about/phases/).

Change notice for Super Bot Fight Mode rulesets

Updating Super Bot Fight Mode rules via the Rulesets API is no longer supported and may cause unexpected behavior if you do so.
