---
title: Pay an outstanding balance · Cloudflare Billing docs
description: "If the automatic retry attempts to take payment fails, and you
  have not manually paid the invoice, your account will have an overdue balance.
  An overdue balance will block you from purchasing new products or
  subscriptions, upgrading existing ones, and you won’t be able to update your
  billing profile until you have successfully paid the balance. Attempts to
  purchase or upgrade subscriptions will return an error mentioning this:"
lastUpdated: 2025-09-03T18:47:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/pay-invoices-overdue-balances/
  md: https://developers.cloudflare.com/billing/pay-invoices-overdue-balances/index.md
---

If the automatic retry attempts to take payment fails, and you have not manually paid the invoice, your account will have an overdue balance. An overdue balance will block you from purchasing new products or subscriptions, upgrading existing ones, and you won’t be able to update your billing profile until you have successfully paid the balance. Attempts to purchase or upgrade subscriptions will return an error mentioning this:

**You cannot add or modify subscriptions or services until the outstanding balance is paid.**

The full range of error messages you may see are:

* "could not run legacy post zone sub request against new zone products: failed to update user subscription: failed to load account from db: You cannot add or modify subscriptions or services until the outstanding balance is paid. You should be able to do so in your Billing page."
* "could not run legacy post zone sub request against new zone products: failed to update user subscription: failed to apply object products: You cannot add or modify subscriptions or services until the outstanding balance is paid. You should be able to do so in your Billing page."
* "failed in ActionAppendSubscription: failed to update user subscription: failed to load account from db: You cannot add or modify subscriptions or services until the outstanding balance is paid. You should be able to do so in your Billing page."
* "could not run a legacy post user sub request: failed to update user subscription: failed to load account from db: You cannot add or modify subscriptions or services until the outstanding balance is paid. You should be able to do so in your Billing page."
* "failed to load account: You cannot add or modify subscriptions or services until the outstanding balance is paid. You should be able to do so in your Billing page."

The simplest way to pay your balance is to click **Pay Now** from your Billing homepage in the Cloudflare dashboard. To see these steps in more detail, refer to [Pay an outstanding balance](#pay-an-outstanding-balance).

You can pay your entire balance in one transaction, or if you have multiple invoices with unpaid amounts, you can choose to pay them individually by following [pay unpaid invoices](#manually-pay-invoices).

## Understand why you have an outstanding balance

Warning

Please note that some unpaid invoices may not be visible. These unpaid invoices will still prevent account modifications. In these cases you should [contact Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

When an outstanding balance is due, a new invoice will be created in your account for that amount. When you view that new invoice, it will show the original invoice number that the outstanding balance relates to. You can look up this original invoice to understand which product(s) were not fully paid for.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Invoices and documents**.

3. Select the most recent invoice - the amount shown should match your outstanding balance

4. On the invoice PDF, look for the section below the **Pay Online** link: **Invoice that pays the following outstanding balance:** and note the invoice number

5. Go back to the **Invoices and documents** section and click to view the invoice number

## Pay an outstanding balance

Note

Allow up to 24 hours for your payment to be recognized and for your account to be in good standing. After that time has passed, you will be able to manage your subscriptions and order more services.

To pay the total outstanding balance:

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Go to the **Pay overdue balances** section.

3. Select **Pay now** next to the balance you want to pay.

You will be redirected to our payment system to proceed.

## Manually pay invoices

If an automatic subscription renewal payment fails, Cloudflare automatically retries the payment using your default payment method five times over five days. During this period, you can log into the dashboard and attempt to manually pay the invoices.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Invoices and documents**.

3. Select **Pay now** next to the invoice you want to pay.

You will be redirected to our payment system to proceed.
