---
title: Overview · Cloudflare AI Crawl Control docs
description: Monitor and control how AI services access your website content.
lastUpdated: 2025-08-27T16:00:59.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/ai-crawl-control/
  md: https://developers.cloudflare.com/ai-crawl-control/index.md
---

Available on all plans

Monitor and control how AI services access your website content.

AI companies use web content to train their models and power AI applications. AI Crawl Control (formerly AI Audit) gives you visibility into which AI services are accessing your content, and provides tools to manage access according to your preferences.

With AI Crawl Control, you can:

* **See which AI services access your content** - Monitor the dashboard to see crawler activity and request patterns
* **Control access with granular policies** - Set allow or block rules for individual crawlers
* **Monitor robots.txt compliance** - Track which crawlers follow your directives and create enforcement rules
* **Explore monetization options** - Set up pay per crawl pricing for content access [(private beta)](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/)
* **Deploy with zero configuration** - Works automatically on all Cloudflare plans

[Get started](https://developers.cloudflare.com/ai-crawl-control/get-started/)

***

## Features

### Manage AI crawlers

Control how AI crawlers interact with your domain.

[Manage AI crawlers](https://developers.cloudflare.com/ai-crawl-control/features/manage-ai-crawlers/)

### Analyze AI traffic

Gain insight into how AI crawlers are interacting with your pages.

[Analyze AI traffic](https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/)

### Pay Per Crawl

Allow AI crawlers to access content by paying per crawl.

[Pay per crawl](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/)

***

## Use cases

Publishers and content creators

Publishers and content creators can monitor which AI crawlers are accessing their articles and educational content. Set policies to allow beneficial crawlers while blocking others.

E-commerce and business sites

E-commerce and business sites can identify AI crawler activity on product pages and business information. Control access to sensitive data like pricing and inventory.

Documentation sites

Documentation sites can track how AI crawlers are accessing their technical documentation. Gain insight into how AI crawlers are engaging with your site.

***

## Related Products

**[Bots](https://developers.cloudflare.com/bots/)**

Identify and mitigate automated traffic to protect your domain from bad bots.

**[Web Application Firewall](https://developers.cloudflare.com/waf/)**

Get automatic protection from vulnerabilities and the flexibility to create custom rules.

**[Analytics](https://developers.cloudflare.com/analytics/)**

View and analyze traffic on your domain.
