---
title: Analyze AI traffic · Cloudflare AI Crawl Control docs
description: AI Crawl Control metrics provide you with insight on how AI
  crawlers are interacting with your website (Cloudflare zone).
lastUpdated: 2025-09-17T08:17:19.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/
  md: https://developers.cloudflare.com/ai-crawl-control/features/analyze-ai-traffic/index.md
---

AI Crawl Control metrics provide you with insight on how AI crawlers are interacting with your website ([Cloudflare zone](https://developers.cloudflare.com/fundamentals/concepts/accounts-and-zones/#zones)).

To view AI Crawl Control metrics:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

2. Go to **AI Crawl Control**.

   [Go to **AI Crawl Control**](https://dash.cloudflare.com/?to=/:account/:zone/ai)

You can find meaningful information across both **Crawlers** and **Metrics** tabs.

## View AI crawler activity

The **Crawlers** tab provides you with the following information:

* Total number of requests to crawl your website from common AI crawlers
* Number of requests made by each AI crawler
* Number of `robots.txt` violations for each crawler

## View AI Crawl Control metrics

The **Metrics** tab provides you with the following metrics to help you understand how AI crawlers are interacting with your website.

| Metric | Description |
| - | - |
| Total requests | The total number of requests to crawl your website, from all AI crawlers |
| Allowed requests | The number of crawler requests that received a successful response from your site |
| Unsuccessful requests | The number of crawler requests that failed (HTTP 4xx or 5xx) as a result of a blocked request, other security rules, or website errors such as a crawler attempting to access a non-existent page |
| Overall popular paths | The most popular pages crawled by AI crawlers, from all AI crawlers |
| Most active AI crawlers by operators | The AI crawler owners with the highest number of requests to access your site |
| Request by AI crawlers | A graph which displays the number of crawl requests from each AI crawler |
| Most popular paths by AI crawlers | The most popular pages crawled by AI crawlers, for each AI crawler |
| Referrals | A graph which displays the number of visits that were directed to your site from each AI operator |
| Referers | The list of referers who directed visits to your site |

## Filter date range

You can use the date filter to choose the period of time you wish to analyze.

* Free plans

  Filter options:

  * Past 24 hours

* Paid plans

  Filter options:

  * Past 24 hours
  * Past 7 days
  * Past 14 days
  * Past month

The values of the AI Crawl Control metrics will update according to your filter.
