---
title: Create an IP access rule · Cloudflare Web Application Firewall (WAF) docs
lastUpdated: 2025-09-19T11:55:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/ip-access-rules/create/
  md: https://developers.cloudflare.com/waf/tools/ip-access-rules/create/index.md
---

Recommendation: Use custom rules instead

Cloudflare recommends that you create [custom rules](https://developers.cloudflare.com/waf/custom-rules/) instead of IP Access rules to perform IP-based or geography-based blocking (geoblocking).

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com), and select your account and domain.

  2. Go to **Security** > **WAF** > **Tools**.

  3. Under **IP Access Rules**, enter the following details:

     1. For **Value**, enter an IP address, IP range, country code/name, or Autonomous System Number (ASN). For details, refer to [Parameters](https://developers.cloudflare.com/waf/tools/ip-access-rules/parameters/).
     2. Select an [action](https://developers.cloudflare.com/waf/tools/ip-access-rules/actions/).
     3. For **Zone**, select whether the rule applies to the current website only or to all websites in the account.
     4. (Optional) Enter a note for the rule (for example, `Payment Gateway`).

  4. Select **Add**.

* New dashboard

  Note

  IP Access Rules are only available in the new security dashboard if you have configured at least one IP access rule. Cloudflare recommends that you use [custom rules](https://developers.cloudflare.com/waf/custom-rules/) instead of IP Access Rules.

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com), and select your account and domain.

  2. Go to **Security** > **Security rules**.

  3. Select **Create rule** > **IP access rules**.

  4. Enter the following rule details:

     1. For **IP, IP range, country name, or ASN**, enter an IP address, IP range, country code/name, or Autonomous System Number (ASN). For details, refer to [Parameters](https://developers.cloudflare.com/waf/tools/ip-access-rules/parameters/).
     2. For **Action**, select an [action](https://developers.cloudflare.com/waf/tools/ip-access-rules/actions/).
     3. For **Zone**, select whether the rule applies to the current website only or to all websites in the account.
     4. (Optional) Enter a note for the rule (for example, `Payment Gateway`).

  5. Select **Create**.

* API

  Use the Cloudflare API to programmatically create IP access rules. For more information, refer to [Create an IP Access Rule](https://developers.cloudflare.com/api/resources/firewall/subresources/access_rules/methods/create/).
