---
title: Create a rate limiting rule in the dashboard · Cloudflare Web Application
  Firewall (WAF) docs
description: When you select the Block action in a rule you can optionally
  define a custom response.
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/
  md: https://developers.cloudflare.com/waf/rate-limiting-rules/create-zone-dashboard/index.md
---

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and zone.

  2. Go to **Security** > **WAF** > **Rate limiting rules**.

  3. To create a new empty rule, select **Create rule**. To duplicate an existing rule, select the three dots next to it > **Duplicate**.

  4. Enter a descriptive name for the rule in **Rule name**.

     ![The Create rate limiting rule page in the Cloudflare dashboard](https://developers.cloudflare.com/_astro/rate-limiting-create.BP_vm64k_1hViTW.webp)

  5. In the **Field** drop-down, choose an HTTP property. For each request, the value of the property you choose for **Field** is compared to the value you specify for **Value** using the operator selected in **Operator**.

  6. (Optional) Under **Cache status**, disable **Also apply rate limiting to cached assets** to consider only the requests that reach the origin when determining the rate.

  7. Under **With the same characteristics**, add one or more [characteristics](https://developers.cloudflare.com/waf/rate-limiting-rules/parameters/#with-the-same-characteristics) that will define the request counters for rate limiting purposes. Each value combination will have its own counter to determine the rate. For more information, refer to [How Cloudflare determines the request rate](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/).

  8. (Optional) To define an expression that specifies the conditions for incrementing the rate counter, enable **Use custom counting expression** and set the expression. By default, the counting expression is the same as the rule expression. The counting expression can include [response fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/?field-category=Response).

  9. (Optional) In **When rate exceeds**, select between:

     * **Request based**: Rate limiting based on the number of incoming requests during a given period.
     * **Complexity based**: Rate limiting based on the complexity or cost of handling requests during a given period.

     Note

     [Complexity-based rate limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/#complexity-based-rate-limiting) is only available to Enterprise customers with Advanced Rate Limiting. Other users will always use request-based rate limiting.

  10. If you selected **Request based** in the previous step (or if you could not select the rate limiting method), enter a value for:

      * **Requests**: Maximum number of requests.
      * **Period**: Time period to consider when determining the rate.

      If you selected **Complexity based**, enter a value for:

      * **Score per period**: Maximum score per period. When this value is exceeded, the rule action will execute.
      * **Period**: Time period to consider when determining the rate.
      * **Response header name**: Name of HTTP header in the response, set by the origin server, with the score for the current request.

  11. Under **Then take action**, select the rule action from the **Choose action** drop-down list. For example, selecting *Block* tells Cloudflare to refuse requests in the conditions you specified when the request limit is reached.

  12. (Optional) If you selected the *Block* action, you can [configure a custom response](#configure-a-custom-response-for-blocked-requests) for requests exceeding the configured rate limit.

  13. Select the mitigation timeout in the **Duration** dropdown. This is the time period during which Cloudflare applies the select action once the rate is reached.

      Enterprise customers with a paid add-on can [throttle requests](https://developers.cloudflare.com/waf/rate-limiting-rules/parameters/#with-the-following-behavior) instead of applying the configured action for a selected duration. To throttle requests, under **With the following behavior** select *Throttle requests over the maximum configured rate*.

  14. To save and deploy your rule, select **Deploy**. If you are not ready to deploy your rule, select **Save as Draft**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and zone.

  2. Go to **Security** > **Security rules**.

  3. To create a new empty rule, select **Create rule** > **Rate limiting rules**. To duplicate an existing rule, select the three dots next to it > **Duplicate**.

  4. []()

     Enter a descriptive name for the rule in **Rule name**.

     ![The Create rate limiting rule page in the Cloudflare dashboard](https://developers.cloudflare.com/_astro/rate-limiting-create.BP_vm64k_1hViTW.webp)

  5. In the **Field** drop-down, choose an HTTP property. For each request, the value of the property you choose for **Field** is compared to the value you specify for **Value** using the operator selected in **Operator**.

  6. (Optional) Under **Cache status**, disable **Also apply rate limiting to cached assets** to consider only the requests that reach the origin when determining the rate.

  7. Under **With the same characteristics**, add one or more characteristics that will define the request counters for rate limiting purposes. Each value combination will have its own counter to determine the rate. Refer to [How Cloudflare determines the request rate](https://developers.cloudflare.com/waf/rate-limiting-rules/request-rate/) for more information.

  8. (Optional) To define an expression that specifies the conditions for incrementing the rate counter, enable **Use custom counting expression** and set the expression. By default, the counting expression is the same as the rule expression. The counting expression can include [response fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/?field-category=Response).

  9. Under **When rate exceeds**, define the maximum number of requests and the time period to consider when determining the rate.

  10. Under **Then take action**, select the rule action from the **Choose action** drop-down list. For example, selecting *Block* tells Cloudflare to refuse requests in the conditions you specified when the request limit is reached.

  11. (Optional) If you selected the *Block* action, you can [configure a custom response](#configure-a-custom-response-for-blocked-requests) for requests exceeding the configured rate limit.

  12. Select the mitigation timeout in the **Duration** dropdown. This is the time period during which Cloudflare applies the select action once the rate is reached.

      Enterprise customers with a paid add-on can [throttle requests](https://developers.cloudflare.com/waf/rate-limiting-rules/parameters/#with-the-following-behavior) instead of applying the configured action for a selected duration. To throttle requests, under **With the following behavior** select *Throttle requests over the maximum configured rate*.

  13. To save and deploy your rule, select **Deploy**. If you are not ready to deploy your rule, select **Save as Draft**.

## Configure a custom response for blocked requests

Note

This feature is only available on Pro plans and above.

When you select the *Block* action in a rule you can optionally define a custom response.

The custom response has three settings:

* **With response type**: Choose a content type or the default rate limiting response from the list. The available custom response types are the following:

  | Dashboard value | API value |
  | - | - |
  | Custom HTML | `"text/html"` |
  | Custom Text | `"text/plain"` |
  | Custom JSON | `"application/json"` |
  | Custom XML | `"text/xml"` |

* **With response code**: Choose an HTTP status code for the response, in the range 400-499. The default response code is 429.

* **Response body**: The body of the response. Configure a valid body according to the response type you selected. The maximum field size is 30 KB.
