---
title: Get started with leaked credentials detection · Cloudflare Web
  Application Firewall (WAF) docs
description: On Free plans, the leaked credentials detection is enabled by
  default, and no action is required. On paid plans, you can turn on the
  detection in the Cloudflare dashboard, via API, or using Terraform.
lastUpdated: 2025-08-27T15:11:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/leaked-credentials/get-started/
  md: https://developers.cloudflare.com/waf/detections/leaked-credentials/get-started/index.md
---

## 1. Turn on the detection

On Free plans, the leaked credentials detection is enabled by default, and no action is required. On paid plans, you can turn on the detection in the Cloudflare dashboard, via API, or using Terraform.

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings**.
  3. Under **Incoming traffic detections**, turn on **Leaked credentials**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Detections**.
  3. Turn on **Leaked credential detection**.

* API

  Use a `POST` request similar to the following:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zone WAF Write`
  * `Account WAF Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/leaked-credential-checks" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "enabled": true
    }'
  ```

* Terraform

  Use the `cloudflare_leaked_credential_check` resource to enable leaked credentials detection for a zone. For example:

  ```terraform
  resource "cloudflare_leaked_credential_check" "zone_lcc_example" {
    zone_id = "<ZONE_ID>"
    enabled = true
  }
  ```

Note

To achieve optimal latency performance, Cloudflare recommends that you turn off [Exposed Credentials Checks](https://developers.cloudflare.com/waf/managed-rules/reference/exposed-credentials-check/) (a previous implementation) after turning on leaked credentials detection and setting up your mitigation strategy as described in the next steps.

## 2. Validate the leaked credentials detection behavior

Use [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) and HTTP logs to validate that Cloudflare is correctly detecting leaked credentials in incoming requests.

Refer to [Test your configuration](#test-your-configuration) for more information on the test credentials you can use to validate your configuration.

Alternatively, create a custom rule like the one described in the next step using a *Log* action (only available to Enterprise customers). This rule will generate [security events](https://developers.cloudflare.com/waf/analytics/security-events/) that will allow you to validate your configuration.

## 3. Mitigate requests with leaked credentials

If you are on a Free plan, deploy the suggested [rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/) template available in:

* Old dashboard: **WAF** > **Rate limiting rules**
* New security dashboard: **Security** > **Security rules**

When you deploy a rule using this template, you get instant protection against IPs attempting to access your application with a leaked password more than five times per 10 seconds. This rule can delay attacks by blocking them for a period of time. Alternatively, you can create a custom rule.

Paid plans have access to more granular controls when creating a rule. If you are on a paid plan, [create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) that challenges requests containing leaked credentials:

| Field | Operator | Value |
| - | - | - |
| User and Password Leaked | equals | True |

If you use the Expression Editor, enter the following expression:

```txt
(cf.waf.credential_check.username_and_password_leaked)
```

Rule action: *Managed Challenge*

This rule will match requests where Cloudflare detects a previously leaked set of credentials (username and password). For a list of fields provided by leaked credentials detection, refer to [Leaked credentials fields](https://developers.cloudflare.com/waf/detections/leaked-credentials/#leaked-credentials-fields).

Combine with other Rules language fields

You can combine the previous expression with other [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/) and [functions](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/) of the Rules language. This allows you to customize the rule scope or combine leaked credential checking with other security features. For example:

* The following expression will match requests containing leaked credentials addressed at an authentication endpoint:

  | Field | Operator | Value | Logic |
  | - | - | - | - |
  | User and Password Leaked | equals | True | And |
  | URI Path | contains | `/admin/login.php` | |

  Expression when using the editor:\
  `(cf.waf.credential_check.username_and_password_leaked and http.request.uri.path contains "/admin/login.php")`

* The following expression will match requests coming from bots that include authentication credentials:

  | Field | Operator | Value | Logic |
  | - | - | - | - |
  | Authentication detected | equals | True | And |
  | Bot Score | less than | `10` | |

  Expression when using the editor:\
  `(cf.waf.auth_detected and cf.bot_management.score lt 10)`

For additional examples, refer to [Example mitigation rules](https://developers.cloudflare.com/waf/detections/leaked-credentials/examples/).

### Handle detected leaked credentials at the origin server

Additionally, you may want to handle leaked credentials detected by Cloudflare at your origin server:

1. [Turn on](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/) the **Add Leaked Credentials Checks Header** managed transform.

2. For requests received at your origin server containing the `Exposed-Credential-Check` header, you could redirect your end users to your reset password page when detecting previously leaked credentials.

## 4. (Optional) Configure a custom detection location

To check for leaked credentials in a way that is not covered by the default configuration, add a [custom detection location](https://developers.cloudflare.com/waf/detections/leaked-credentials/#custom-detection-locations).

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **Settings**.

  3. Under **Incoming traffic detections**, select **Leaked credentials** and then select **Add custom username and password location**.

  4. In **Username location** and **Password location** (optional), enter expressions for obtaining the username and the password from the HTTP request. For example, you could use the following expressions:

     * Username location:\
       `lookup_json_string(http.request.body.raw, "user")`
     * Password location:\
       `lookup_json_string(http.request.body.raw, "secret")`

     This configuration will scan incoming HTTP requests containing a JSON body with a structure similar to the following:

     ```js
     {"user": "<USERNAME>", "secret": "<PASSWORD>"}
     ```

     Refer to the [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string) documentation for more information on this function.

  5. Select **Save**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **Settings** and filter by **Detections**.

  3. Under **Leaked credential detection** > **Configurations**, select the edit icon.

  4. Select **Add custom username and password location**.

  5. In **Username location** and **Password location** (optional), enter expressions for obtaining the username and the password from the HTTP request. For example, you could use the following expressions:

     * Username location:\
       `lookup_json_string(http.request.body.raw, "user")`
     * Password location:\
       `lookup_json_string(http.request.body.raw, "secret")`

     This configuration will scan incoming HTTP requests containing a JSON body with a structure similar to the following:

     ```js
     {"user": "<USERNAME>", "secret": "<PASSWORD>"}
     ```

     Refer to the [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string) documentation for more information on this function.

  6. Select **Save**.

* API

  Use a `POST` request similar to the following:

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Zone WAF Write`
  * `Account WAF Write`

  ```bash
  curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/leaked-credential-checks/detections" \
    --request POST \
    --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
    --json '{
      "username": "lookup_json_string(http.request.body.raw, \"user\")",
      "password": "lookup_json_string(http.request.body.raw, \"secret\")"
    }'
  ```

  This pair of lookup expressions (for username and password) will scan incoming HTTP requests containing a JSON body with a structure similar to the following:

  ```js
  {"user": "<USERNAME>", "secret": "<PASSWORD>"}
  ```

  Refer to the [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string) documentation for more information on this function.

* Terraform

  Use the `cloudflare_leaked_credential_check_rule` resource to add a custom detection location. For example:

  ```terraform
  resource "cloudflare_leaked_credential_check_rule" "custom_location_example" {
    zone_id = "<ZONE_ID>"
    username = "lookup_json_string(http.request.body.raw, \"user\")"
    password = "lookup_json_string(http.request.body.raw, \"secret\")"
  }
  ```

  Refer to the [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string) documentation for more information on this function.

You only need to provide an expression for the username in custom detection locations.

For more examples of custom detection locations for different request types, refer to [Custom detection locations](https://developers.cloudflare.com/waf/detections/leaked-credentials/#custom-detection-locations).

***

## Test your configuration

Cloudflare provides a special set of case-sensitive credentials for testing the configuration of the leaked credentials detection.

After enabling and configuring the detection, you can use the credentials mentioned in this section in your test HTTP requests.

Test credentials for users on a Free plan (will also work in paid plans):

* Username: `CF_LEAKED_USERNAME_FREE`
* Password: `CF_LEAKED_PASSWORD`

Test credentials for users on paid plans (will not work on Free plans):

* Username: `CF_EXPOSED_USERNAME` or `CF_EXPOSED_USERNAME@example.com`
* Password: `CF_EXPOSED_PASSWORD`

Cloudflare considers these specific credentials as having been previously leaked. Use them in your tests to check the behavior of your current configuration.
