---
title: Manage account members | Cloudflare Docs
description: In this video, learn how to define the roles and permission scope
  for members associated with an account.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/videos/manage-account-members/
  md: https://developers.cloudflare.com/videos/manage-account-members/index.md
---

In this video, learn how to define the roles and permission scope for members associated with an account.



Transcript

Account members are users who have access to your Cloudflare account.

Each member's access is controlled by policies which define their roles and the

scope of their permissions.

In order to grant access to account members.

You must be a super administrator with a verified email address.

In this video, we'll walk through how to view members,

add new members, edit their permissions, resend invitations,

and revoke access in Cloudflare dashboard.

Let's first take a look at how to view members.

Start by logging in to the Cloudflare dashboard and selecting your account.

Go to Manage Account Members.

Here you can see the list of current account members.

Now let's move on to adding account members.

On the members page to invite someone new, select invite.

Enter one or more email addresses.

Define the scope of their access.

Choose one or more roles such as administrator or billing.

Click continue to summary.

Review the details, then select invite.

If the person already has a Cloudflare account and you're on an enterprise plan,

you can use Direct Add instead of sending an email invitation.

If you want to change a member's access and permissions.

First open the record and select edit, adjust their roles or scope,

then select continue to summary.

Review the changes and select update.

If an invite is pending and the user hasn't accepted,

this is how you can resend it from the member's page.

Find a pending user, open the record and choose Resend Invite to revoke someone's

access. Expand their record.

Select, revoke and confirm.

If you were added as a member and you want to remove yourself.

Go to the member's page, locate your record and select leave.

If you're a super administrator and you need to leave the account,

you can invite another super administrator before you remove yourself.

You cannot delete the account itself, but other super administrators will retain

full privileges. Cloudflare also supports user groups,

which let you manage permissions for a set of members collectively.

Members inherit all roles assigned to the group in addition to any directly assigned

permissions. For more information on account members and user groups,

visit our developer documentation.
