---
title: Navigation · Cloudflare Style Guide
description: The purpose of a navigation page is to direct users deeper into the
  doc set and act as a sub-landing page for a specific area of the docs.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/navigation/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/navigation/index.md
---

## Purpose

The purpose of a navigation page is to direct users deeper into the doc set and act as a sub-landing page for a specific area of the docs.

## content\_type

```yaml
pcx_content_type: navigation
```

For more details, refer to [`pcx_content_type`](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#pcx_content_type).

## Components

[`DirectoryListing`](https://developers.cloudflare.com/style-guide/components/directory-listing/):

Use `<DirectoryListing />` to display the directory of a specific folder, which appears as a list of links.

## Template

```mdx
---
weight: xx
pcx_content_type: navigation
---


import { DirectoryListing } from "~/components";


# Name of section


<DirectoryListing />
```

## Examples

[Logs: Enable destinations](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/)

[Cloudflare Tunnel: Get Started](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/get-started/)
