---
title: Content types · Cloudflare Style Guide
description: All new developers.cloudflare.com products should include the
  required content sections that are listed in the following table. The other
  sections are available depending on what information users need to
  successfully use the product.
lastUpdated: 2024-08-27T20:38:31.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/index.md
---

All new [developers.cloudflare.com](https://developers.cloudflare.com/) products should include the required content sections that are listed in the following table. The other sections are available depending on what information users need to successfully use the product.

| Content section | Required? | Content description |
| - | - | - |
| [Overview](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/overview/) | Yes | The purpose of a landing page is to welcome users and provide an overview of the product. |
| [Get started](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/get-started/) | Yes | The purpose of Get started content is to help users go from not using a product to successfully configuring and setting up. |
| [How to](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/how-to/) | No | The purpose of a how to is to explain how to complete a task within the product. |
| [Concept](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/concept/) | No | The purpose of a concept is to provide conceptual or descriptive information so users understand the background and context of a particular topic. |
| [Reference](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference/) | No | The purpose of reference content is to provide supplemental information (a “deep dive”) for further learning on settings, values, or options. While reference information is helpful for users, reference information should not block or prevent users from completing tasks. |
| [Reference architecture](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture/) | No | The purpose of a reference architecture is to provide a high-level view of how all or part of the Cloudflare platform is built and how Cloudflare products would fit into a customer's existing infrastructure. |
| [Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/) | No | The purpose of a tutorial is to guide users and connect products to real-world scenarios. |
| [API](https://developers.cloudflare.com/style-guide/api-content-strategy/api-content-types/) | No | API content lists requirements and tasks users must complete before successfully making their first request. |
| [Troubleshooting](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/troubleshooting/) | No | The purpose of Troubleshooting content is to provide guidance for solving common and corner-case problems with the product. |
| [FAQ](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/faq/) | No | The purpose of an FAQ is to provide simple answers to common questions. |
| [3rd-party integration guide](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/3rd-party-integration-guide/) | No | The purpose of a 3rd-party integration guide is to explain how to use a 3rd-party product with Cloudflare. |
| [Changelog](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/changelog/) | No | The purpose of a changelog is to log or record notable changes. |
| [Configuration](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/configuration/) | No | The purpose of a configuration is to show examples of specific settings, values, and options. |
| [Navigation](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/navigation/) | No | The purpose of a navigation page is to direct users deeper into the doc set and act as a sub-landing page for a specific area of the docs. |
| [Support content](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/support-content/) | No | The purpose of support content is to provide guidance for solving specific problems with Cloudflare. |
