---
title: GitHubCode · Cloudflare Style Guide
description: The GitHubCode component allows you to include files from
  Cloudflare repositories.
lastUpdated: 2025-07-09T16:38:41.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/github-code/
  md: https://developers.cloudflare.com/style-guide/components/github-code/index.md
---

The `GitHubCode` component allows you to include files from Cloudflare repositories.

The remote content can be filtered by lines or a region enclosed in tags.

## Import

```mdx
import { GitHubCode } from "~/components";
```

## Usage

### Filtering by lines

```mdx
import { GitHubCode } from "~/components";


{/*
import { foo } from "bar";


const baz = foo();


console.log(baz);
*/}
<GitHubCode
    repo="..."
    file="..."
    commit="..."
    lang="..."
    lines="1-3"
/>
{/*
import { foo } from "bar";


const baz = foo();
*/}
```

### Filtering by tag

```mdx
import { GitHubCode } from "~/components";


{/*
<docs-tag name="no-logging">
import { foo } from "bar";


const baz = foo();
</docs-tag name="no-logging">


console.log(baz);
*/}
<GitHubCode
    repo="..."
    file="..."
    commit="..."
    lang="..."
    tag="no-logging"
/>
{/*
import { foo } from "bar";


const baz = foo();
*/}
```

## `<GitHubCode>` Props

### `repo`

**required** **type:** `string`

The owner and repository to pull from, in the form of `cloudflare/<REPO-NAME>`

For example:

* `cloudflare/workers-rs`.
* `cloudflare/templates`.

### `file`

**required** **type:** `string`

The file path to pull from, in the form of `path/to/filename-including-extensions`. This path excludes the repo name.

For example:

* `templates/hello-world/src/lib.rs`.
* `d1-starter-sessions-api/src/index.ts`.

### `commit`

**required** **type:** `string`

The long (40-characters) Git commit hash to pull from, for example `ab3951b5c95329a600a7baa9f9bb1a7a95f1aeaa`.

### `lang`

**required** **type:** `string`

The language to use for the code block, for example `rs`.

### `useTypeScriptExample`

**type:** `boolean`

If the `lang` is `"ts"` and `useTypeScriptExample` is `true`, the [`TypeScriptExample`](https://developers.cloudflare.com/style-guide/components/typescript-example/) component will be used to provide a JavaScript tab as well.

### `lines`

**type:** `string`

A range of lines to filter the content using, for example `1-3`.

### `tag`

**type:** `string`

A region to filter the content with, for example `no-logging`.

This should be represented as starting `<docs-tag name="no-logging">` and closing `</docs-tag name="no-logging">` comments in the source file.

### `code`

**type**: `object`

Props to pass to the [Expressive Code component](https://expressive-code.com/key-features/code-component/).

## Associated content types

* [Tutorial](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/)
