---
title: Ports · Cloudflare Sandbox SDK docs
description: Expose services running in your sandbox via public preview URLs.
  See Preview URLs concept for details.
lastUpdated: 2025-10-15T15:03:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/sandbox/api/ports/
  md: https://developers.cloudflare.com/sandbox/api/ports/index.md
---

Expose services running in your sandbox via public preview URLs. See [Preview URLs concept](https://developers.cloudflare.com/sandbox/concepts/preview-urls/) for details.

## Methods

### `exposePort()`

Expose a port and get a preview URL.

```ts
const response = await sandbox.exposePort(port: number, options?: ExposePortOptions): Promise<ExposePortResponse>
```

**Parameters**:

* `port` - Port number to expose (1024-65535)
* `options` (optional):
  * `name` - Friendly name for the port

**Returns**: `Promise<ExposePortResponse>` with `port`, `exposedAt` (preview URL), `name`

* JavaScript

  ```js
  await sandbox.startProcess("python -m http.server 8000");
  const exposed = await sandbox.exposePort(8000);


  console.log("Available at:", exposed.exposedAt);
  // https://abc123-8000.sandbox.workers.dev


  // Multiple services with names
  await sandbox.startProcess("node api.js");
  const api = await sandbox.exposePort(3000, { name: "api" });


  await sandbox.startProcess("npm run dev");
  const frontend = await sandbox.exposePort(5173, { name: "frontend" });
  ```

* TypeScript

  ```ts
  await sandbox.startProcess('python -m http.server 8000');
  const exposed = await sandbox.exposePort(8000);


  console.log('Available at:', exposed.exposedAt);
  // https://abc123-8000.sandbox.workers.dev


  // Multiple services with names
  await sandbox.startProcess('node api.js');
  const api = await sandbox.exposePort(3000, { name: 'api' });


  await sandbox.startProcess('npm run dev');
  const frontend = await sandbox.exposePort(5173, { name: 'frontend' });
  ```

### `unexposePort()`

Remove an exposed port and close its preview URL.

```ts
await sandbox.unexposePort(port: number): Promise<void>
```

**Parameters**:

* `port` - Port number to unexpose

- JavaScript

  ```js
  await sandbox.unexposePort(8000);
  ```

- TypeScript

  ```ts
  await sandbox.unexposePort(8000);
  ```

### `getExposedPorts()`

Get information about all currently exposed ports.

```ts
const response = await sandbox.getExposedPorts(): Promise<GetExposedPortsResponse>
```

**Returns**: `Promise<GetExposedPortsResponse>` with `ports` array (containing `port`, `exposedAt`, `name`)

* JavaScript

  ```js
  const { ports } = await sandbox.getExposedPorts();


  for (const port of ports) {
    console.log(`${port.name || port.port}: ${port.exposedAt}`);
  }
  ```

* TypeScript

  ```ts
  const { ports } = await sandbox.getExposedPorts();


  for (const port of ports) {
    console.log(`${port.name || port.port}: ${port.exposedAt}`);
  }
  ```

## Related resources

* [Preview URLs concept](https://developers.cloudflare.com/sandbox/concepts/preview-urls/) - How preview URLs work
* [Commands API](https://developers.cloudflare.com/sandbox/api/commands/) - Start background processes
