---
title: Rewrite links on HTML pages · Cloudflare Rules docs
description: Dynamically rewrite links in HTML responses. This is useful for
  site migrations and branding updates.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/
  md: https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/index.md
---

```js
export default {
  async fetch(request) {
    // Define the old hostname here.
    const OLD_URL = "oldsite.com";
    // Then add your new hostname that should replace the old one.
    const NEW_URL = "newsite.com";


    class AttributeRewriter {
      constructor(attributeName) {
        this.attributeName = attributeName;
      }
      element(element) {
        const attribute = element.getAttribute(this.attributeName);
        if (attribute) {
          element.setAttribute(
            this.attributeName,
            attribute.replace(OLD_URL, NEW_URL),
          );
        }
      }
    }


    const rewriter = new HTMLRewriter()
      .on("a", new AttributeRewriter("href"))
      .on("img", new AttributeRewriter("src"));


    const res = await fetch(request);
    if (!res.headers.has("Content-Type")) {
      return res;
    }
    const contentType = res.headers.get("Content-Type");
    if (typeof contentType !== "string") {
      return res;
    }


    // If the response is HTML, it can be transformed with
    // HTMLRewriter -- otherwise, it should pass through
    if (contentType.startsWith("text/html")) {
      return rewriter.transform(res);
    } else {
      return res;
    }
  },
};
```
