---
title: Configuration settings · Cloudflare Page Shield docs
description: When enabled, Page Shield's client-side resource monitoring uses a
  Content Security Policy (CSP) report-only HTTP header to gather information
  about all the scripts running on your application.
lastUpdated: 2025-08-29T08:22:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/page-shield/reference/settings/
  md: https://developers.cloudflare.com/page-shield/reference/settings/index.md
---

## Reporting endpoint

When enabled, Page Shield's client-side resource monitoring uses a Content Security Policy (CSP) [report-only HTTP header](https://developers.cloudflare.com/page-shield/reference/csp-header/) to gather information about all the scripts running on your application.

By default, reports are sent to a Cloudflare-owned endpoint:

```txt
https://csp-reporting.cloudflare.com/cdn-cgi/script_monitor/report?<QUERY_STRING>
```

Enterprise customers with a paid add-on can change the reporting endpoint so that the CSP reports are sent to the same hostname:

```txt
<YOUR-HOSTNAME>/cdn-cgi/script-monitor/report?<QUERY_STRING>
```

### Prerequisites for using the same hostname for CSP reports

Using the same hostname for CSP reporting may interfere with other Cloudflare products. Before selecting this option, ensure that your Cloudflare configuration complies with the following:

* No rate limiting rules match the `cdn-cgi/*` URL path
* No custom rules match the `cdn-cgi/*` URL path

### Configure the reporting endpoint

Note

Only available to Enterprise customers with a paid add-on.

To configure the CSP reporting endpoint:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Page Shield** > **Settings**.
  3. Under **Reporting endpoint**, select **Cloudflare-owned endpoint** or **Same hostname**.
  4. Select **Apply settings**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Client-side abuse**.
  3. Under **Continuous script monitoring** > **Configurations**, select the edit icon next to **Reporting endpoint**.
  4. Select **Cloudflare-owned endpoint** or **Same hostname**.
  5. Select **Save**.

## Connection target details

When connection targets are reported to Cloudflare, their URIs can sometimes include sensitive data such as session ID.

By default, Page Shield will only check the domain against malicious threat intelligence feeds. You can choose to let Page Shield use the full URI when analyzing the connections made from your domain's pages. Any sensitive data present in the URI will be logged in clear text, and any user with access to the connection monitor dashboard will be able to view it.

### Configure the connection target details to use

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Page Shield** > **Settings**.
  3. Under **Connection target details**, select **Log host only** to analyze only the hostname or **Log full URI** to use the full URI in Page Shield.
  4. Select **Apply settings**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Client-side abuse**.
  3. Under **Continuous script monitoring** > **Configurations**, select the edit icon next to **Data processing**.
  4. Select **Log host only** to analyze only the hostname or **Log full URI** to use the full URI.
  5. Select **Save**.

## Turn off client-side resource monitoring

When you turn off Page Shield's client-side resource monitoring, you lose visibility on the scripts running on your zone, the outbound connections made from pages in your domain, and cookies detected in HTTP traffic.

To turn off client-side resource monitoring:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Page Shield** > **Settings**.
  3. In **Disable Page Shield**, select **Disable**.

* New dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **Settings** and filter by **Client-side abuse**.
  3. Next to **Continuous script monitoring**, set the toggle to **Off**.

Note

Turning off Page Shield's client-side resource monitoring will not turn off [policies](https://developers.cloudflare.com/page-shield/policies/) (also known as content security rules). To turn off policies:

* Old dashboard: Go to **Security** > **Page Shield** > **Policies**.
* New security dashboard: Go to **Security** > **Security rules** and filter by **Content security rules**.
