---
title: Rules · Cloudflare Magic Network Monitoring docs
description: Magic Network Monitoring rules allow you to monitor your network
  traffic for DDoS attacks on specific IP addresses or IP prefixes within your
  network. If the network traffic that is monitored by a rule exceeds the rule's
  threshold or contains a DDoS attack fingerprint, then you will receive an
  alert.
lastUpdated: 2025-10-16T11:21:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/rules/
  md: https://developers.cloudflare.com/magic-network-monitoring/rules/index.md
---

Magic Network Monitoring rules allow you to monitor your network traffic for DDoS attacks on specific IP addresses or IP prefixes within your network. If the network traffic that is monitored by a rule exceeds the rule's threshold or contains a DDoS attack fingerprint, then you will receive an alert.

## Rule types

There are three different types of rules that can be configured within Magic Network Monitoring. You can refer to the linked documentation page for each rule type to learn more.

| Rule Type | Rule Description | Rule Availability |
| - | - | - |
| [Dynamic threshold](https://developers.cloudflare.com/magic-network-monitoring/rules/dynamic-threshold/) (recommended) | A dynamic threshold rule will analyze a network's traffic patterns over time and automatically adjust the rule's DDoS threshold, in terms of bits or packets, based on traffic history. | API configuration only |
| [Static threshold](https://developers.cloudflare.com/magic-network-monitoring/rules/static-threshold/) | A static threshold rule allows you to define a constant numeric threshold, in terms of bits or packets, for DDoS traffic monitoring. | API configuration and dashboard configuration |
| [sFlow DDoS attack](https://developers.cloudflare.com/magic-network-monitoring/rules/s-flow-ddos-attack/) | Magic Network Monitoring customers that send sFlow data to Cloudflare can receive alerts when a specific type of distributed denial-of-service (DDoS) attack is detected within their network traffic. | API configuration only. Only applicable to sFlow data sets |

## Create rules in the dashboard

You can only configure static traffic threshold rules in the Cloudflare dashboard.

Invalid account settings error when trying to create a rule

If you get the following error when trying to create a rule:

`Invalid account settings request body: account name format contains illegal characters or is not supported`

Make sure the name for your Cloudflare account does not contain unsupported characters, like, for example, `&`, `<`, `>`, `"`, `'`, `` ` ``.

Refer to [Account name](https://developers.cloudflare.com/fundamentals/account/create-account/#account-name) to learn how to change your account name.

To create a new rule:

1. In the Cloudflare dashboard, go to the **Magic Monitoring** page.

[Go to **Magic monitoring**](https://dash.cloudflare.com/?to=/:account/network-monitoring)

1. Select **Configure Magic Network Monitoring** > **Add new rule**.
2. Create a new static traffic threshold rule according to your needs. Refer to the documentation on [static threshold](https://developers.cloudflare.com/magic-network-monitoring/rules/static-threshold/) rules for more information on each field in the static threshold rule's configuration.
3. Select **Create a new rule** when you are finished.

## Edit rules in the dashboard

1. In the Cloudflare dashboard, go to the **Magic Monitoring** page.

[Go to **Magic monitoring**](https://dash.cloudflare.com/?to=/:account/network-monitoring)

1. Select **Configure Magic Network Monitoring**.
2. Find the static threshold rule you want to edit, and select **Edit**.
3. Edit the appropriate fields. Refer to [Rule configuration fields](https://developers.cloudflare.com/magic-network-monitoring/rules/static-threshold/#rule-configuration-fields) for more information on what each field does.
4. Select **Save** when you are finished.

## Delete rules in the dashboard

1. In the Cloudflare dashboard, go to the **Magic Monitoring** page.

[Go to **Magic monitoring**](https://dash.cloudflare.com/?to=/:account/network-monitoring)

1. Select **Configure Magic Network Monitoring**.
2. Find the static threshold rule you want to delete, and select **Delete**.
3. Select **I understand that deleting a rule is permanent**, and select **Delete** again.

## Common settings that apply to all rule types

### Rule Auto-Advertisement

If you are an Enterprise customer using [Magic Transit On Demand](https://developers.cloudflare.com/magic-transit/on-demand), you can enable **Auto-Advertisement** for any dynamic threshold, static threshold, and sFlow DDoS attack rule. The Auto-Advertisement feature will automatically activate Magic Transit when a static or dynamic rule threshold is exceeded or a DDoS attack fingerprint is identified in sFlow traffic logs.

Follow the previous steps to [create](#create-rules-in-the-dashboard) or [edit](#edit-rules-in-the-dashboard) a rule. Then, enable **Auto-Advertisement**.

#### Rule Auto-Advertisement notifications

Webhook, PagerDuty, and email notifications are sent following an auto-advertisement attempt for all prefixes inside the flagged rule.

You will receive the status of the advertisement for each prefix with the following available statuses:

* **Advertised**: The prefix was successfully advertised.
* **Already Advertised**: The prefix was advertised prior to the auto advertisement attempt.
* **Delayed**: The prefix cannot currently be advertised but will attempt advertisement. After the prefix can be advertised, a new notification is sent with the updated status.
* **Locked**: The prefix is locked and cannot be advertised.
* **Could not Advertise**: Cloudflare was unable to advertise the prefix. This status can occur for multiple reasons, but usually occurs when you are not allowed to advertise a prefix.
* **Error**: A general error occurred during prefix advertisement.

### Rule IP prefixes

Each rule must include a group of IP prefixes in its definition. All IP prefixes inside a rule are evaluated as a whole, and you should set up a rule with multiple IP prefixes when you want the IP prefixes' aggregated traffic to trigger an alert or advertisement. For thresholds on singular IP prefixes or IP addresses, you can create an individual rule with one prefix and the desired rule parameters.

#### Rule IP prefixes example

For a rule with two prefix CIDRs and a `packet_threshold` of `10000` as shown below, the rule will be flagged if the joint packet traffic of `192.168.0.0/24` and `172.118.0.0/24` is greater than `10000`. This also means that Cloudflare attempts to auto advertise both CIDRs if the rule has the auto advertisement flag enabled. Customers can also [configure Rule IP prefixes at scale via Cloudflare's API](https://developers.cloudflare.com/api/resources/magic_network_monitoring/subresources/rules/).

```json
"rules":[
        "name": "Too many packets",
        "prefixes": ["192.168.0.0/24", "172.118.0.0/24"],
        "packet_threshold": 10000,
        "automatic_advertisement": true,
        "duration": "1m0s",
   "type": "threshold"
        ]
```

For more granular thresholds, create a more focused rule as shown below.

```json
"rules":[
        "name": "Too many packets",
        "prefixes": ["172.118.0.0/24"],
        "packet_threshold": 1000,
        "automatic_advertisement": true,
        "duration": "1m0s",
 "type": "threshold"
       ]
```
