---
title: Magic IDS Detections · Cloudflare Logs docs
description: The descriptions below detail the fields available for magic_ids_detections.
lastUpdated: 2025-07-25T16:42:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/magic_ids_detections/
  md: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/magic_ids_detections/index.md
---

The descriptions below detail the fields available for `magic_ids_detections`.

## Action

Type: `string`

What action was taken on the packet. Possible values are *pass* | *block*.

## ColoCity

Type: `string`

The city where the detection occurred.

## ColoCode

Type: `string`

The IATA airport code corresponding to where the detection occurred.

## DestinationIP

Type: `string`

The destination IP of the packet which triggered the detection.

## DestinationPort

Type: `int`

The destination port of the packet which triggered the detection. It is set to 0 if the protocol field is set to *any*.

## Protocol

Type: `string`

The layer 4 protocol of the packet which triggered the detection. Possible values are *tcp* | *udp* | *any*. Variant *any* means a detection occurred at a lower layer (such as IP).

## SignatureID

Type: `int`

The signature ID of the detection.

## SignatureMessage

Type: `string`

The signature message of the detection. Describes what the packet is attempting to do.

## SignatureRevision

Type: `int`

The signature revision of the detection.

## SourceIP

Type: `string`

The source IP of packet which triggered the detection.

## SourcePort

Type: `int`

The source port of the packet which triggered the detection. It is set to 0 if the protocol field is set to *any*.

## Timestamp

Type: `int or string`

A timestamp of when the detection occurred.
