---
title: Changelog · Cloudflare Load Balancing docs
description: You can now create more granular, network-aware Custom Rules in
  Cloudflare Load Balancing using the Autonomous System Number (ASN) of an
  incoming request.
lastUpdated: 2025-05-06T18:53:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/changelog/
  md: https://developers.cloudflare.com/load-balancing/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/load-balancing.xml)

## 2025-08-15

**Steer Traffic by AS Number in Load Balancing Custom Rules**

You can now create more granular, network-aware Custom Rules in Cloudflare Load Balancing using the Autonomous System Number (ASN) of an incoming request.

This allows you to steer traffic with greater precision based on the network source of a request. For example, you can route traffic from specific Internet Service Providers (ISPs) or enterprise customers to dedicated infrastructure, optimize performance, or enforce compliance by directing certain networks to preferred data centers.

![Create a Load Balancing Custom Rule using AS Num](https://developers.cloudflare.com/_astro/asnum-custom-rule.CtcHu_zj_2bK7ax.webp)

To get started, create a [Custom Rule](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/) in your Load Balancer and select **AS Num** from the **Field** dropdown.

## 2025-08-06

**Improvements to Monitoring Using Zone Settings**

Cloudflare Load Balancing Monitors support loading and applying settings for a specific zone to monitoring requests to origin endpoints. This feature has been migrated to new infrastructure to improve reliability, performance, and accuracy.

All zone monitors have been tested against the new infrastructure. There should be no change to health monitoring results of currently healthy and active pools. Newly created or re-enabled pools may need validation of their monitor zone settings before being introduced to service, especially regarding correct application of mTLS.

#### What you can expect:

* More reliable application of zone settings to monitoring requests, including

  * Authenticated Origin Pulls
  * Aegis Egress IP Pools
  * Argo Smart Routing
  * HTTP/2 to Origin

* Improved support and bug fixes for retries, redirects, and proxied origin resolution

* Improved performance and reliability of monitoring requests withing the Cloudflare network

* Unrelated CDN or WAF configuration changes should have no risk of impact to pool health

## 2025-06-04

**New Account-Level Load Balancing UI and Private Load Balancers**

We've made two large changes to load balancing:

* Redesigned the user interface, now centralized at the **account level**.
* Introduced [**Private Load Balancers**](https://developers.cloudflare.com/load-balancing/private-network/) to the UI, enabling you to manage traffic for all of your external and internal applications in a single spot.

This update streamlines how you manage load balancers across multiple zones and extends robust traffic management to your private network infrastructure.

![Load Balancing UI](https://developers.cloudflare.com/_astro/account-load-balancing-ui.CoCi7gPb_K7D8r.webp)

**Key Enhancements:**

* **Account-Level UI Consolidation:**

  * **Unified Management:** Say goodbye to navigating individual zones for load balancing tasks. You can now view, configure, and monitor all your load balancers across every zone in your account from a single, intuitive interface at the account level.

  * **Improved Efficiency:** This centralized approach provides a more streamlined workflow, making it faster and easier to manage both your public-facing and internal traffic distribution.

* **Private Network Load Balancing:**

  * **Secure Internal Application Access:** Create [**Private Load Balancers**](https://developers.cloudflare.com/load-balancing/private-network/) to distribute traffic to applications hosted within your private network, ensuring they are not exposed to the public Internet.

  * **WARP & Magic WAN Integration:** Effortlessly direct internal traffic from users connected via Cloudflare WARP or through your Magic WAN infrastructure to the appropriate internal endpoint pools.

  * **Enhanced Security for Internal Resources:** Combine reliable Load Balancing with Zero Trust access controls to ensure your internal services are both performant and only accessible by verified users.

![Private Load Balancers](https://developers.cloudflare.com/_astro/private-load-balancer.yti20m_p_2bqVH4.webp)

## 2025-05-06

**UDP and ICMP Monitor Support for Private Load Balancing Endpoints**

Cloudflare Load Balancing now supports **UDP (Layer 4)** and **ICMP (Layer 3)** health monitors for **private endpoints**. This makes it simple to track the health and availability of internal services that don’t respond to HTTP, TCP, or other protocol probes.

#### What you can do:

* Set up **ICMP ping monitors** to check if your private endpoints are reachable.
* Use **UDP monitors** for lightweight health checks on non-TCP workloads, such as DNS, VoIP, or custom UDP-based services.
* Gain better visibility and uptime guarantees for services running behind **Private Network Load Balancing**, without requiring public IP addresses.

This enhancement is ideal for internal applications that rely on low-level protocols, especially when used in conjunction with [**Cloudflare Tunnel**](https://developers.cloudflare.com/cloudflare-one/connections/connect-networks/), [**WARP**](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/), and [**Magic WAN**](https://developers.cloudflare.com/magic-wan/) to create a secure and observable private network.

Learn more about [Private Network Load Balancing](https://developers.cloudflare.com/load-balancing/private-network/) or view the full list of [supported health monitor protocols](https://developers.cloudflare.com/load-balancing/monitors/#supported-protocols).

## 2025-04-15

**Introducing Support for Orange-Clouded Origin Resolution**

Newly created Cloudflare Load Balancers will resolve orange-clouded origin addresses, provided the origins belong to the same account and zone as the Load Balancer. Existing Load Balancers will continue using the current resolution method. If ownership validation fails, the new system falls back to the existing behavior and defaults to a gray-clouded (DNS-only) lookup, typically resolving to anycast addresses.

## 2025-03-13

**Update to Load Balancing analytics**

Load Balancing request rates in analytics may decrease for some customers as an improvement is made to our infrastructure. This decrease in Load Balancing analytics does not indicate a decrease in HTTP requests received.

## 2025-02-20

**Zone name added to Load Balancing API responses**

Load Balancing API responses for Load Balancers now include a `zone_name` property, which provides the name of the zone in the response data.

## 2025-02-10

**Fix for Cloudflare Tunnel Consistency**

Fixes to improve the consistency of Cloudflare Tunnel handling within Cloudflare Load Balancers. These changes ensure more reliable and predictable routing, particularly when tunnels are involved.

## 2025-01-24

**Update to Cloudflare Tunnel Steering**

Introduced changes to the resolution of proxied domains that are backed by Cloudflare Tunnels on the same zone. These changes correct how orange-clouded records are steered to Cloudflare Tunnels via Cloudflare Load Balancers.

## 2025-01-16

**Update to Pool Health Monitoring**

We made changes to how we resolve and monitor proxied origins to assess pool health. Our analysis indicates no impact to customer configurations or operations. Contact customer support if you notice any unexpected behavior.

## 2024-12-20

**Load Balancing with the China Network**

You can now enable load balancers to be deployed to the [China Network](https://developers.cloudflare.com/china-network/). Refer to the [documentation](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-china/) for more details.
