---
title: Cloudflare IP addresses · Cloudflare Fundamentals docs
description: Cloudflare has several IP address ranges which are shared by all
  proxied hostnames.
lastUpdated: 2025-07-18T14:20:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/
  md: https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/index.md
---

Cloudflare has several [IP address ranges](https://www.cloudflare.com/ips/) which are shared by all proxied hostnames.

Together, these IP addresses form the backbone of our [anycast network](https://www.cloudflare.com/learning/cdn/glossary/anycast-network/), helping distribute traffic amongst various edge network servers.

Note

Cloudflare uses other IP ranges for various products and services, but these addresses will not make connections to your origin.

## Allow Cloudflare IP addresses

All traffic to [proxied DNS records](https://developers.cloudflare.com/dns/proxy-status/) passes through Cloudflare before reaching your origin server. This means that your origin server will stop receiving traffic from individual visitor IP addresses and instead receive traffic from [Cloudflare IP addresses](https://www.cloudflare.com/ips), which are shared by all proxied hostnames.

This setup can cause issues if your origin server blocks or rate limits connections from Cloudflare IP addresses. Because all visitor traffic will appear to come from Cloudflare IP addresses, blocking these IPs — even accidentally — will prevent visitor traffic from reaching your application.

In addition, allowing Cloudflare IPs might be needed to avoid rate limiting or blocking these requests at your origin server.

For [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers, Cloudflare routes the traffic instead of proxying it. Once Cloudflare starts advertising your IP prefixes, it will accept IP packets destined for your network, process them, and then output these packets to your origin infrastructure.

## Configure origin server

### Allowlist Cloudflare IP addresses

To avoid blocking Cloudflare IP addresses unintentionally, you also want to allow Cloudflare IP addresses at your origin web server.

You can explicitly allow these IP addresses with a [.htaccess file](https://httpd.apache.org/docs/trunk/mod/mod_authz_core.html#require) or by using [iptables](https://www.linode.com/docs/security/firewalls/control-network-traffic-with-iptables/#block-or-allow-traffic-by-port-number-to-create-an-iptables-firewall).

The following example demonstrates how you could use an iptables rule to allow a Cloudflare IP address range. Replace `$ip` below with one of the [Cloudflare IP address ranges](https://www.cloudflare.com/ips).

```bash
# For IPv4 addresses
$ iptables -I INPUT -p tcp -m multiport --dports http,https -s $ip -j ACCEPT


# For IPv6 addresses
$ ip6tables -I INPUT -p tcp -m multiport --dports http,https -s $ip -j ACCEPT
```

For more specific guidance, contact your hosting provider or website administrator.

### Block other IP addresses (recommended)

As a best practice, we also recommend that you explicitly block all traffic that does not come from Cloudflare IP addresses or the IP addresses of your trusted partners, vendors, or applications.

For example, you might [update your iptables](https://www.linode.com/docs/guides/control-network-traffic-with-iptables/#block-or-allow-traffic-by-port-number-to-create-an-iptables-firewall) with the following commands:

```sh
# For IPv4 addresses
iptables -A INPUT -p tcp -m multiport --dports http,https -j DROP
# For IPv6 addresses
ip6tables -A INPUT -p tcp -m multiport --dports http,https -j DROP
```

For more specific guidance, contact your hosting provider or website administrator.

## Review external tools

To avoid blocking Cloudflare IP addresses unintentionally, review your external tools to check that:

* Any security plugins — such as those for WordPress — allow Cloudflare IP addresses.
* The [ModSecurity](https://github.com/SpiderLabs/ModSecurity) plugin is up to date.

### Additional recommendations

#### Further protection

For further recommendations on securing your origin server, refer to our guide on [protecting your origin server](https://developers.cloudflare.com/fundamentals/security/protect-your-origin-server/).

### Customize Cloudflare IP addresses

If they do not want to use Cloudflare IP addresses — which are shared by all proxied hostnames — Enterprise customers have two potential alternatives:

* [**Bring Your Own IP (BYOIP)**](https://developers.cloudflare.com/byoip/): Cloudflare announces your IPs (an IP address range you lease/own) in all of our [locations](https://www.cloudflare.com/network/).
* **Static IP addresses**: Cloudflare sets static IP addresses for your domain. For more details, contact your account team.

Business and Enterprise customers can also reduce the number of Cloudflare IPs that their domain shares with other Cloudflare customer domains by [uploading a Custom SSL certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/).

### IP range updates

Cloudflare's IP ranges do not change frequently. When they do change, they are added to our [list of IP ranges](https://www.cloudflare.com/en-in/ips/) before being put into production. You can also use the Cloudflare API to programmatically keep your configuration updated.
