---
title: Set up CNAME flattening · Cloudflare DNS docs
description: CNAME flattening occurs by default for all plans when your domain
  uses a CNAME record for its zone apex (example.com, meaning the record Name is
  set to @).
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/
  md: https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/index.md
---

Note

If the CNAME target is on the same zone as the CNAME record, Cloudflare proceeds with CNAME flattening and ignores the **CNAME Flattening** setting.

## For your zone apex

CNAME flattening occurs by default for all plans when your domain uses a CNAME record for its zone apex (`example.com`, meaning the record **Name** is set to `@`).

## For all CNAME records

For zones on paid plans, you can choose to flatten all CNAME records. This option is useful for DNS-only (unproxied) CNAME records. [Proxied records](https://developers.cloudflare.com/dns/proxy-status/) are flattened by default as they return Cloudflare anycast IPs.

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account and domain.
  2. Go to **DNS** > **Settings**.
  3. Turn on the option **CNAME flattening for all CNAME records**.

* API

  Make a `PATCH` request to the [Update DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/zone/methods/edit/) endpoint and set `flatten_all_cnames` to `true` in the request body.

Warning

If a CNAME target is being used to verify a domain for a third-party service, turning on [CNAME flattening for all CNAME records](https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/#for-all-cname-records) may cause the verification to fail since the CNAME record itself will not be returned directly.

## Per record

Paid zones also have the option of flattening specific CNAME records.

If you use this option, a special [tag](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/) `cf-flatten-cname` will be added to the respective flattened CNAME records in your zone file, allowing you to [export and import records](https://developers.cloudflare.com/dns/manage-dns-records/how-to/import-and-export/) without losing this configuration.

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login) and select your account and domain.
  2. In **DNS** > **Settings**, make sure that **CNAME flattening for all CNAME records** is turned off.
  3. Go to **DNS** > **Records** and find the CNAME record you would like to flatten.
  4. Select **Edit** and turn on the **Flatten** option.
  5. Select **Save** to confirm.

  Unavailable flatten option

  For the following cases, **Flatten** will not be available:

  * The record is at the [zone apex](#for-your-zone-apex).
  * The record is already proxied, which means it will be flattened by default.
  * **CNAME flattening for all CNAME records** is turned on, which means you cannot override it per record.

* API

  With the available [API endpoints](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/), specify the following for each CNAME record in the request body:

  ```txt
  "settings": {
    "flatten_cname": true
  }
  ```
