---
title: Data location · Cloudflare D1 docs
description: Learn how the location of data stored in D1 is determined,
  including where the leader is placed and how you optimize that location based
  on your needs.
lastUpdated: 2025-09-03T16:40:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/d1/configuration/data-location/
  md: https://developers.cloudflare.com/d1/configuration/data-location/index.md
---

Learn how the location of data stored in D1 is determined, including where the leader is placed and how you optimize that location based on your needs.

## Automatic (recommended)

By default, D1 will automatically create your primary database instance in a location close to where you issued the request to create a database. In most cases this allows D1 to choose the optimal location for your database on your behalf.

## Provide a location hint

Location hint is an optional parameter you can provide to indicate your desired geographical location for your primary database instance.

You may want to explicitly provide a location hint in cases where the majority of your writes to a specific database come from a different location than where you are creating the database from. Location hints can be useful when:

* Working in a distributed team.
* Creating databases specific to users in specific locations.
* Using continuous deployment (CD) or Infrastructure as Code (IaC) systems to programmatically create your databases.

Provide a location hint when creating a D1 database when:

* Using [`wrangler d1`](https://developers.cloudflare.com/workers/wrangler/commands/#d1) to create a database.
* Creating a database [via the Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/workers/d1).

Warning

Providing a location hint does not guarantee that D1 runs in your preferred location. Instead, it will run in the nearest possible location (by latency) to your preference.

### Use Wrangler

Note

To install Wrangler, the command-line interface for D1 and Workers, refer to [Install and Update Wrangler](https://developers.cloudflare.com/workers/wrangler/install-and-update/).

To provide a location hint when creating a new database, pass the `--location` flag with a valid location hint:

```sh
wrangler d1 create new-database --location=weur
```

### Use the dashboard

To provide a location hint when creating a database via the dashboard:

1. In the Cloudflare dashboard, go to the **D1** page.

   [Go to **D1 SQL database**](https://dash.cloudflare.com/?to=/:account/workers/d1)

2. Select **Create database**.

3. Provide a database name and an optional **Location**.

4. Select **Create** to create your database.

## Available location hints

D1 supports the following location hints:

| Hint | Hint description |
| - | - |
| wnam | Western North America |
| enam | Eastern North America |
| weur | Western Europe |
| eeur | Eastern Europe |
| apac | Asia-Pacific |
| oc | Oceania |

Warning

D1 location hints are not currently supported for South America (`sam`), Africa (`afr`), and the Middle East (`me`). D1 databases do not run in these locations.

## Read replica locations

With read replication enabled, D1 creates and distributes read-only copies of the primary database instance around the world. This reduces the query latency for users located far away from the primary database instance.

When using D1 read replication, D1 automatically creates a read replica in [every available region](https://developers.cloudflare.com/d1/configuration/data-location#available-location-hints), including the region where the primary database instance is located.

Refer to [D1 read replication](https://developers.cloudflare.com/d1/best-practices/read-replication/) for more information.
