---
title: SSO integration · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust allows you to integrate your organization's
  identity providers (IdPs) with Cloudflare Access. Your team can simultaneously
  use multiple providers, reducing friction when working with partners or
  contractors.
lastUpdated: 2025-09-23T20:48:09.000Z
chatbotDeprioritize: false
tags: SSO
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/
  md: https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/index.md
---

Cloudflare Zero Trust allows you to integrate your organization's identity providers (IdPs) with Cloudflare Access. Your team can simultaneously use multiple providers, reducing friction when working with partners or contractors.

Adding an identity provider as a login method requires configuration both in [Zero Trust](https://one.dash.cloudflare.com) and with the identity provider itself. Consult our IdP-specific documentation to learn more about what you need to set up.

Note

Cloudflare Zero Trust supports social identity providers that do not require administrator accounts, open source providers, and corporate providers. Cloudflare also supports using signed AuthN requests with SAML providers.

## Set up IdPs in Zero Trust

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Authentication**.

  2. In the **Login methods** card, select **Add new**.

  3. Select the identity provider you want to add.

     If you do not see your identity provider listed, these providers can typically still be enabled. If they support OIDC or OAuth, select the [generic OIDC](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-oidc/) option. If they support SAML, select the [generic SAML](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-saml/) option. Cloudflare supports all SAML and OIDC providers and can integrate with the majority of OAuth providers. If your provider supports both SAML and OIDC, we recommend OIDC for ease of configuration.

  4. Fill in the necessary fields to set up your identity provider.

     Each identity provider will have different required fields for you to fill in. Step-by-step instructions are shown in the dashboard side panel. Alternatively, refer to the [IdP-specific documentation](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/).

  5. Once you have filled in the necessary fields, select **Save**.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Access: Organizations, Identity Providers, and Groups Write`

  2. Add an identity provider to Zero Trust using the [`cloudflare_zero_trust_access_identity_provider`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_access_identity_provider) resource. For example, to add a Microsoft Entra ID integration:

     ```tf
     resource "cloudflare_zero_trust_access_identity_provider" "microsoft_entra_id" {
       account_id = var.cloudflare_account_id
       name       = "Entra ID example"
       type       = "azureAD"
       config      = {
         client_id                  = var.entra_id_client_id
         client_secret              = var.entra_id_client_secret
         directory_id               = var.entra_id_directory_id
         support_groups             = true
         }
     }
     ```

     Each identity provider integration has different required attributes. You will need to obtain these attribute values from your identity provider. For more information, refer to the [IdP-specific documentation](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/).

     If you do not see your identity provider listed, these providers can typically still be enabled. If they support OIDC or OAuth, use the [generic OIDC](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-oidc/) option. If they support SAML, use the [generic SAML](https://developers.cloudflare.com/cloudflare-one/identity/idp-integration/generic-saml/) option. Cloudflare supports all SAML and OIDC providers and can integrate with the majority of OAuth providers. If your provider supports both SAML and OIDC, we recommend OIDC for ease of configuration.

Your IdP will now be listed in the **Login methods** card.

## Test IdPs in Zero Trust

To test if an IdP is correctly configured, go to **Settings** > **Authentication**. Next, select **Test** next to the IdP you would like to test. This will attempt to connect to the IdP to verify if a valid connection is established.

### Your provider is connected

If your provider is connected, another window will open in your browser, with this message:

!["Your connection works!" message displayed for a successful IdP test](https://developers.cloudflare.com/_astro/connected-idp.Dc_ZasM0_1Amy4H.webp)

### Your provider is not connected

If your provider is not connected, another window will open in your browser. Along with an error message, you will receive a detailed explanation of why the test has failed.

## Use The API

We recommend that you use our dashboard to configure your identity providers. However, if you would like to use the [Cloudflare API](https://api.cloudflare.com/), each of the identity provider topics covered here include an example API configuration snippet as well.
