---
title: Device serial numbers · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust allows you to build Zero Trust rules based on
  device serial numbers. You can create these rules so that access to
  applications is granted only to users connecting from company devices.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/corp-device/
  md: https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/corp-device/index.md
---

Cloudflare Zero Trust allows you to build Zero Trust rules based on device serial numbers. You can create these rules so that access to applications is granted only to users connecting from company devices.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/).

## Create a list of serial numbers

To create rules based on device serial numbers, you first need to create a [Gateway List](https://developers.cloudflare.com/cloudflare-one/policies/gateway/lists/) of numbers.

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **My Team** > **Lists**.

2. Select **Create manual list** or **Upload CSV**. For larger teams, we recommend uploading a CSV or using Cloudflare's [API endpoint](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/lists/methods/list/).

3. Give your list a descriptive name, as this name will appear when configuring your policies.

4. Set **List Type** to *Serial numbers*.

5. Enter the serial numbers of the devices your team manages, or upload your CSV file.

6. Select **Save**.

You can now create an [Access policy](https://developers.cloudflare.com/cloudflare-one/policies/access/) or a Gateway [network policy](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/common-policies/#enforce-device-posture) that checks if the device presents a serial number on your list. In Access, the serial number check will appear as a *Device Posture - Serial Number List* selector. In Gateway, your serial number list will appear in the **Value** dropdown when you choose the [Passed Device Posture Check](https://developers.cloudflare.com/cloudflare-one/policies/gateway/network-policies/#device-posture) selector.

## Validate the serial number

You can use the following commands to check the serial number of your device. The results can help you validate if the posture check is working as expected.

### macOS

1. Open a terminal window.

2. Use the `system_profiler` command to check for the value of `SPHardwareDataType` and retrieve the serial number.

   ```sh
   system_profiler SPHardwareDataType | grep 'Serial Number'
   ```

### Windows

1. Open a PowerShell window.

2. Use the `Get-CimInstance` command to get the SerialNumber property of the `Win32_BIOS` class.

   ```powershell
   Get-CimInstance Win32_BIOS
   ```

### Linux

1. Open a Terminal Window

2. Use the `dmidecode` command to get the version property `system-serial-number`.

   ```sh
   sudo dmidecode -s system-serial-number
   ```

### iOS, Android and ChromeOS

Serial number checks are not supported on mobile devices. You can identify mobile devices by a [unique client ID](https://developers.cloudflare.com/cloudflare-one/identity/devices/warp-client-checks/device-uuid) instead of by serial number.
