---
title: Get started with Network Analytics · Cloudflare Analytics docs
description: Learn how to view and use data from Network Analytics.
lastUpdated: 2025-09-04T10:57:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/network-analytics/get-started/
  md: https://developers.cloudflare.com/analytics/network-analytics/get-started/index.md
---

Requirements

Network Analytics requires the following:

* A Cloudflare Enterprise plan.
* Cloudflare Magic Transit or Spectrum.
* Cloudflare Magic WAN.

## View the Network Analytics dashboard

1. In the Cloudflare dashboard, go to the **Network Analytics** page.

   [Go to **Network analytics**](https://dash.cloudflare.com/?to=/:account/network-analytics)

2. Select an account that has access to Magic Transit or Spectrum.

3. Configure the displayed data. You can [adjust the time range](https://developers.cloudflare.com/analytics/network-analytics/configure/time-range/), [select the main metric](https://developers.cloudflare.com/analytics/network-analytics/configure/displayed-data/#select-high-level-metric) (total packets or total bytes), [apply filters](https://developers.cloudflare.com/analytics/network-analytics/configure/displayed-data/#apply-filters), and more.

## Get Network Analytics data via API

Use the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/) to query data using the available [Network Analytics nodes](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/).

## Send Network Analytics logs to a third-party service

[Create a Logpush job](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/) that sends Network analytics logs to your storage service, SIEM solution, or log management provider.

## Limitations

Users with the `Analytics` role will have visibility to IDs but will not see the following on the Network Analytics dashboard:

* Tunnel names
* Prefix names
* [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) rules
* [DDoS managed rulesets](https://developers.cloudflare.com/ddos-protection/managed-rulesets/)
* Override names
