---
title: DNS over TLS · Cloudflare 1.1.1.1 docs
description: By default, DNS is sent over a plaintext connection. DNS over TLS
  (DoT) is one way to send DNS queries over an encrypted connection. Cloudflare
  supports DNS over TLS on standard port 853 and is compliant with RFC 7858.
  With DoT, the encryption happens at the transport layer, where it adds TLS
  encryption on top of a TCP connection.
lastUpdated: 2024-11-19T17:02:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-tls/
  md: https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-tls/index.md
---

By default, DNS is sent over a plaintext connection. DNS over TLS (DoT) is one way to send DNS queries over an encrypted connection. Cloudflare supports DNS over TLS on standard port 853 and is compliant with [RFC 7858](https://tools.ietf.org/html/rfc7858). With DoT, the encryption happens at the transport layer, where it adds TLS encryption on top of a TCP connection.

## How it works

Cloudflare supports DNS over TLS (DoT) on `1.1.1.1`, `1.0.0.1`, and the corresponding IPv6 addresses (`2606:4700:4700::1111` and `2606:4700:4700::1001`) on port `853`. If your DoT client does not support IP addresses, Cloudflare's DoT endpoint can also be reached by hostname on `one.one.one.one`. A stub resolver (the DNS client on a device that talks to the DNS resolver) connects to the resolver over a TLS connection:

1. Before the connection, the DNS stub resolver has stored a base64 encoded SHA256 hash of the TLS certificate from 1.1.1.1 (called SPKI).
2. DNS stub resolver establishes a TCP connection with `1.1.1.1:853`.
3. DNS stub resolver initiates a TLS handshake.
4. In the TLS handshake, 1.1.1.1 presents its TLS certificate.
5. Once the TLS connection is established, the DNS stub resolver can send DNS over an encrypted connection, preventing eavesdropping and tampering.
6. All DNS queries sent over the TLS connection must comply with specifications of [sending DNS over TCP](https://tools.ietf.org/html/rfc1035#section-4.2.2).

## Example

```sh
kdig -d @1.1.1.1 +tls-ca +tls-host=one.one.one.one example.com
```

```sh
;; DEBUG: Querying for owner(example.com.), class(1), type(1), server(1.1.1.1), port(853), protocol(TCP)
;; DEBUG: TLS, imported 138 system certificates
;; DEBUG: TLS, received certificate hierarchy:
;; DEBUG:  #1, C=US,ST=California,L=San Francisco,O=Cloudflare\, Inc.,CN=cloudflare-dns.com
;; DEBUG:      SHA-256 PIN: GP8Knf7qBae+aIfythytMbYnL+yowaWVeD6MoLHkVRg=
;; DEBUG:  #2, C=US,O=DigiCert Inc,CN=DigiCert TLS Hybrid ECC SHA384 2020 CA1
;; DEBUG:      SHA-256 PIN: e0IRz5Tio3GA1Xs4fUVWmH1xHDiH2dMbVtCBSkOIdqM=
;; DEBUG: TLS, skipping certificate PIN check
;; DEBUG: TLS, The certificate is trusted.
;; TLS session (TLS1.3)-(ECDHE-X25519)-(ECDSA-SECP256R1-SHA256)-(AES-256-GCM)
;; ->>HEADER<<- opcode: QUERY; status: NOERROR; id: 3395
;; Flags: qr rd ra; QUERY: 1; ANSWER: 1; AUTHORITY: 0; ADDITIONAL: 1


;; EDNS PSEUDOSECTION:
;; Version: 0; flags: ; UDP size: 1232 B; ext-rcode: NOERROR
;; PADDING: 408 B


;; QUESTION SECTION:
;; example.com.            IN  A


;; ANSWER SECTION:
example.com.          75897  IN  A  93.184.216.34


;; Received 468 B
;; Time 2023-06-23 18:05:42 PDT
;; From 1.1.1.1@853(TCP) in 12.1 ms
```

## Supported TLS versions

Cloudflare's DNS over TLS supports TLS 1.3 and TLS 1.2.
